/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.serverlessapplicationrepository.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.serverlessapplicationrepository.model.transform.ApplicationPolicyStatementMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ApplicationPolicyStatement
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> actions;
    private List<String> principals;
    private String statementId;

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(Collection<String> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<String>(actions);
    }

    public ApplicationPolicyStatement withActions(String ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<String>(actions.length));
        }
        for (String ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public ApplicationPolicyStatement withActions(Collection<String> actions) {
        this.setActions(actions);
        return this;
    }

    public List<String> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Collection<String> principals) {
        if (principals == null) {
            this.principals = null;
            return;
        }
        this.principals = new ArrayList<String>(principals);
    }

    public ApplicationPolicyStatement withPrincipals(String ... principals) {
        if (this.principals == null) {
            this.setPrincipals(new ArrayList<String>(principals.length));
        }
        for (String ele : principals) {
            this.principals.add(ele);
        }
        return this;
    }

    public ApplicationPolicyStatement withPrincipals(Collection<String> principals) {
        this.setPrincipals(principals);
        return this;
    }

    public void setStatementId(String statementId) {
        this.statementId = statementId;
    }

    public String getStatementId() {
        return this.statementId;
    }

    public ApplicationPolicyStatement withStatementId(String statementId) {
        this.setStatementId(statementId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getPrincipals() != null) {
            sb.append("Principals: ").append(this.getPrincipals()).append(",");
        }
        if (this.getStatementId() != null) {
            sb.append("StatementId: ").append(this.getStatementId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationPolicyStatement)) {
            return false;
        }
        ApplicationPolicyStatement other = (ApplicationPolicyStatement)obj;
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getPrincipals() == null ^ this.getPrincipals() == null) {
            return false;
        }
        if (other.getPrincipals() != null && !other.getPrincipals().equals(this.getPrincipals())) {
            return false;
        }
        if (other.getStatementId() == null ^ this.getStatementId() == null) {
            return false;
        }
        return other.getStatementId() == null || other.getStatementId().equals(this.getStatementId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipals() == null ? 0 : this.getPrincipals().hashCode());
        hashCode = 31 * hashCode + (this.getStatementId() == null ? 0 : this.getStatementId().hashCode());
        return hashCode;
    }

    public ApplicationPolicyStatement clone() {
        try {
            return (ApplicationPolicyStatement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationPolicyStatementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

