/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securitylake.model.AwsLogSourceType;
import com.amazonaws.services.securitylake.model.Region;
import com.amazonaws.services.securitylake.model.transform.AutoEnableNewRegionConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AutoEnableNewRegionConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String region;
    private List<String> sources;

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public AutoEnableNewRegionConfiguration withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public AutoEnableNewRegionConfiguration withRegion(Region region) {
        this.region = region.toString();
        return this;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(Collection<String> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<String>(sources);
    }

    public AutoEnableNewRegionConfiguration withSources(String ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<String>(sources.length));
        }
        for (String ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public AutoEnableNewRegionConfiguration withSources(Collection<String> sources) {
        this.setSources(sources);
        return this;
    }

    public AutoEnableNewRegionConfiguration withSources(AwsLogSourceType ... sources) {
        ArrayList<String> sourcesCopy = new ArrayList<String>(sources.length);
        for (AwsLogSourceType value : sources) {
            sourcesCopy.add(value.toString());
        }
        if (this.getSources() == null) {
            this.setSources(sourcesCopy);
        } else {
            this.getSources().addAll(sourcesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoEnableNewRegionConfiguration)) {
            return false;
        }
        AutoEnableNewRegionConfiguration other = (AutoEnableNewRegionConfiguration)obj;
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        return other.getSources() == null || other.getSources().equals(this.getSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        return hashCode;
    }

    public AutoEnableNewRegionConfiguration clone() {
        try {
            return (AutoEnableNewRegionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoEnableNewRegionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

