/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.securityhub.model.AwsSecurityFindingIdentifier;
import com.amazonaws.services.securityhub.model.NoteUpdate;
import com.amazonaws.services.securityhub.model.RelatedFinding;
import com.amazonaws.services.securityhub.model.SeverityUpdate;
import com.amazonaws.services.securityhub.model.VerificationState;
import com.amazonaws.services.securityhub.model.WorkflowUpdate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchUpdateFindingsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<AwsSecurityFindingIdentifier> findingIdentifiers;
    private NoteUpdate note;
    private SeverityUpdate severity;
    private String verificationState;
    private Integer confidence;
    private Integer criticality;
    private List<String> types;
    private Map<String, String> userDefinedFields;
    private WorkflowUpdate workflow;
    private List<RelatedFinding> relatedFindings;

    public List<AwsSecurityFindingIdentifier> getFindingIdentifiers() {
        return this.findingIdentifiers;
    }

    public void setFindingIdentifiers(Collection<AwsSecurityFindingIdentifier> findingIdentifiers) {
        if (findingIdentifiers == null) {
            this.findingIdentifiers = null;
            return;
        }
        this.findingIdentifiers = new ArrayList<AwsSecurityFindingIdentifier>(findingIdentifiers);
    }

    public BatchUpdateFindingsRequest withFindingIdentifiers(AwsSecurityFindingIdentifier ... findingIdentifiers) {
        if (this.findingIdentifiers == null) {
            this.setFindingIdentifiers(new ArrayList<AwsSecurityFindingIdentifier>(findingIdentifiers.length));
        }
        for (AwsSecurityFindingIdentifier ele : findingIdentifiers) {
            this.findingIdentifiers.add(ele);
        }
        return this;
    }

    public BatchUpdateFindingsRequest withFindingIdentifiers(Collection<AwsSecurityFindingIdentifier> findingIdentifiers) {
        this.setFindingIdentifiers(findingIdentifiers);
        return this;
    }

    public void setNote(NoteUpdate note) {
        this.note = note;
    }

    public NoteUpdate getNote() {
        return this.note;
    }

    public BatchUpdateFindingsRequest withNote(NoteUpdate note) {
        this.setNote(note);
        return this;
    }

    public void setSeverity(SeverityUpdate severity) {
        this.severity = severity;
    }

    public SeverityUpdate getSeverity() {
        return this.severity;
    }

    public BatchUpdateFindingsRequest withSeverity(SeverityUpdate severity) {
        this.setSeverity(severity);
        return this;
    }

    public void setVerificationState(String verificationState) {
        this.verificationState = verificationState;
    }

    public String getVerificationState() {
        return this.verificationState;
    }

    public BatchUpdateFindingsRequest withVerificationState(String verificationState) {
        this.setVerificationState(verificationState);
        return this;
    }

    public BatchUpdateFindingsRequest withVerificationState(VerificationState verificationState) {
        this.verificationState = verificationState.toString();
        return this;
    }

    public void setConfidence(Integer confidence) {
        this.confidence = confidence;
    }

    public Integer getConfidence() {
        return this.confidence;
    }

    public BatchUpdateFindingsRequest withConfidence(Integer confidence) {
        this.setConfidence(confidence);
        return this;
    }

    public void setCriticality(Integer criticality) {
        this.criticality = criticality;
    }

    public Integer getCriticality() {
        return this.criticality;
    }

    public BatchUpdateFindingsRequest withCriticality(Integer criticality) {
        this.setCriticality(criticality);
        return this;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(Collection<String> types) {
        if (types == null) {
            this.types = null;
            return;
        }
        this.types = new ArrayList<String>(types);
    }

    public BatchUpdateFindingsRequest withTypes(String ... types) {
        if (this.types == null) {
            this.setTypes(new ArrayList<String>(types.length));
        }
        for (String ele : types) {
            this.types.add(ele);
        }
        return this;
    }

    public BatchUpdateFindingsRequest withTypes(Collection<String> types) {
        this.setTypes(types);
        return this;
    }

    public Map<String, String> getUserDefinedFields() {
        return this.userDefinedFields;
    }

    public void setUserDefinedFields(Map<String, String> userDefinedFields) {
        this.userDefinedFields = userDefinedFields;
    }

    public BatchUpdateFindingsRequest withUserDefinedFields(Map<String, String> userDefinedFields) {
        this.setUserDefinedFields(userDefinedFields);
        return this;
    }

    public BatchUpdateFindingsRequest addUserDefinedFieldsEntry(String key, String value) {
        if (null == this.userDefinedFields) {
            this.userDefinedFields = new HashMap<String, String>();
        }
        if (this.userDefinedFields.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.userDefinedFields.put(key, value);
        return this;
    }

    public BatchUpdateFindingsRequest clearUserDefinedFieldsEntries() {
        this.userDefinedFields = null;
        return this;
    }

    public void setWorkflow(WorkflowUpdate workflow) {
        this.workflow = workflow;
    }

    public WorkflowUpdate getWorkflow() {
        return this.workflow;
    }

    public BatchUpdateFindingsRequest withWorkflow(WorkflowUpdate workflow) {
        this.setWorkflow(workflow);
        return this;
    }

    public List<RelatedFinding> getRelatedFindings() {
        return this.relatedFindings;
    }

    public void setRelatedFindings(Collection<RelatedFinding> relatedFindings) {
        if (relatedFindings == null) {
            this.relatedFindings = null;
            return;
        }
        this.relatedFindings = new ArrayList<RelatedFinding>(relatedFindings);
    }

    public BatchUpdateFindingsRequest withRelatedFindings(RelatedFinding ... relatedFindings) {
        if (this.relatedFindings == null) {
            this.setRelatedFindings(new ArrayList<RelatedFinding>(relatedFindings.length));
        }
        for (RelatedFinding ele : relatedFindings) {
            this.relatedFindings.add(ele);
        }
        return this;
    }

    public BatchUpdateFindingsRequest withRelatedFindings(Collection<RelatedFinding> relatedFindings) {
        this.setRelatedFindings(relatedFindings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFindingIdentifiers() != null) {
            sb.append("FindingIdentifiers: ").append(this.getFindingIdentifiers()).append(",");
        }
        if (this.getNote() != null) {
            sb.append("Note: ").append(this.getNote()).append(",");
        }
        if (this.getSeverity() != null) {
            sb.append("Severity: ").append(this.getSeverity()).append(",");
        }
        if (this.getVerificationState() != null) {
            sb.append("VerificationState: ").append(this.getVerificationState()).append(",");
        }
        if (this.getConfidence() != null) {
            sb.append("Confidence: ").append(this.getConfidence()).append(",");
        }
        if (this.getCriticality() != null) {
            sb.append("Criticality: ").append(this.getCriticality()).append(",");
        }
        if (this.getTypes() != null) {
            sb.append("Types: ").append(this.getTypes()).append(",");
        }
        if (this.getUserDefinedFields() != null) {
            sb.append("UserDefinedFields: ").append(this.getUserDefinedFields()).append(",");
        }
        if (this.getWorkflow() != null) {
            sb.append("Workflow: ").append(this.getWorkflow()).append(",");
        }
        if (this.getRelatedFindings() != null) {
            sb.append("RelatedFindings: ").append(this.getRelatedFindings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFindingsRequest)) {
            return false;
        }
        BatchUpdateFindingsRequest other = (BatchUpdateFindingsRequest)obj;
        if (other.getFindingIdentifiers() == null ^ this.getFindingIdentifiers() == null) {
            return false;
        }
        if (other.getFindingIdentifiers() != null && !other.getFindingIdentifiers().equals(this.getFindingIdentifiers())) {
            return false;
        }
        if (other.getNote() == null ^ this.getNote() == null) {
            return false;
        }
        if (other.getNote() != null && !other.getNote().equals(this.getNote())) {
            return false;
        }
        if (other.getSeverity() == null ^ this.getSeverity() == null) {
            return false;
        }
        if (other.getSeverity() != null && !other.getSeverity().equals(this.getSeverity())) {
            return false;
        }
        if (other.getVerificationState() == null ^ this.getVerificationState() == null) {
            return false;
        }
        if (other.getVerificationState() != null && !other.getVerificationState().equals(this.getVerificationState())) {
            return false;
        }
        if (other.getConfidence() == null ^ this.getConfidence() == null) {
            return false;
        }
        if (other.getConfidence() != null && !other.getConfidence().equals(this.getConfidence())) {
            return false;
        }
        if (other.getCriticality() == null ^ this.getCriticality() == null) {
            return false;
        }
        if (other.getCriticality() != null && !other.getCriticality().equals(this.getCriticality())) {
            return false;
        }
        if (other.getTypes() == null ^ this.getTypes() == null) {
            return false;
        }
        if (other.getTypes() != null && !other.getTypes().equals(this.getTypes())) {
            return false;
        }
        if (other.getUserDefinedFields() == null ^ this.getUserDefinedFields() == null) {
            return false;
        }
        if (other.getUserDefinedFields() != null && !other.getUserDefinedFields().equals(this.getUserDefinedFields())) {
            return false;
        }
        if (other.getWorkflow() == null ^ this.getWorkflow() == null) {
            return false;
        }
        if (other.getWorkflow() != null && !other.getWorkflow().equals(this.getWorkflow())) {
            return false;
        }
        if (other.getRelatedFindings() == null ^ this.getRelatedFindings() == null) {
            return false;
        }
        return other.getRelatedFindings() == null || other.getRelatedFindings().equals(this.getRelatedFindings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFindingIdentifiers() == null ? 0 : this.getFindingIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getNote() == null ? 0 : this.getNote().hashCode());
        hashCode = 31 * hashCode + (this.getSeverity() == null ? 0 : this.getSeverity().hashCode());
        hashCode = 31 * hashCode + (this.getVerificationState() == null ? 0 : this.getVerificationState().hashCode());
        hashCode = 31 * hashCode + (this.getConfidence() == null ? 0 : this.getConfidence().hashCode());
        hashCode = 31 * hashCode + (this.getCriticality() == null ? 0 : this.getCriticality().hashCode());
        hashCode = 31 * hashCode + (this.getTypes() == null ? 0 : this.getTypes().hashCode());
        hashCode = 31 * hashCode + (this.getUserDefinedFields() == null ? 0 : this.getUserDefinedFields().hashCode());
        hashCode = 31 * hashCode + (this.getWorkflow() == null ? 0 : this.getWorkflow().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedFindings() == null ? 0 : this.getRelatedFindings().hashCode());
        return hashCode;
    }

    public BatchUpdateFindingsRequest clone() {
        return (BatchUpdateFindingsRequest)super.clone();
    }
}

