/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.ProcessingJob;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ProcessingJobMarshaller {
    private static final MarshallingInfo<List> PROCESSINGINPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessingInputs").build();
    private static final MarshallingInfo<StructuredPojo> PROCESSINGOUTPUTCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessingOutputConfig").build();
    private static final MarshallingInfo<String> PROCESSINGJOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessingJobName").build();
    private static final MarshallingInfo<StructuredPojo> PROCESSINGRESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessingResources").build();
    private static final MarshallingInfo<StructuredPojo> STOPPINGCONDITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StoppingCondition").build();
    private static final MarshallingInfo<StructuredPojo> APPSPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppSpecification").build();
    private static final MarshallingInfo<Map> ENVIRONMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Environment").build();
    private static final MarshallingInfo<StructuredPojo> NETWORKCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NetworkConfig").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").build();
    private static final MarshallingInfo<StructuredPojo> EXPERIMENTCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExperimentConfig").build();
    private static final MarshallingInfo<String> PROCESSINGJOBARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessingJobArn").build();
    private static final MarshallingInfo<String> PROCESSINGJOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessingJobStatus").build();
    private static final MarshallingInfo<String> EXITMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExitMessage").build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureReason").build();
    private static final MarshallingInfo<Date> PROCESSINGENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessingEndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> PROCESSINGSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProcessingStartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTMODIFIEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> MONITORINGSCHEDULEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MonitoringScheduleArn").build();
    private static final MarshallingInfo<String> AUTOMLJOBARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoMLJobArn").build();
    private static final MarshallingInfo<String> TRAININGJOBARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingJobArn").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final ProcessingJobMarshaller instance = new ProcessingJobMarshaller();

    public static ProcessingJobMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProcessingJob processingJob, ProtocolMarshaller protocolMarshaller) {
        if (processingJob == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(processingJob.getProcessingInputs(), PROCESSINGINPUTS_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getProcessingOutputConfig(), PROCESSINGOUTPUTCONFIG_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getProcessingJobName(), PROCESSINGJOBNAME_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getProcessingResources(), PROCESSINGRESOURCES_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getStoppingCondition(), STOPPINGCONDITION_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getAppSpecification(), APPSPECIFICATION_BINDING);
            protocolMarshaller.marshall(processingJob.getEnvironment(), ENVIRONMENT_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getNetworkConfig(), NETWORKCONFIG_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getExperimentConfig(), EXPERIMENTCONFIG_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getProcessingJobArn(), PROCESSINGJOBARN_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getProcessingJobStatus(), PROCESSINGJOBSTATUS_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getExitMessage(), EXITMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getFailureReason(), FAILUREREASON_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getProcessingEndTime(), PROCESSINGENDTIME_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getProcessingStartTime(), PROCESSINGSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getLastModifiedTime(), LASTMODIFIEDTIME_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getMonitoringScheduleArn(), MONITORINGSCHEDULEARN_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getAutoMLJobArn(), AUTOMLJOBARN_BINDING);
            protocolMarshaller.marshall((Object)processingJob.getTrainingJobArn(), TRAININGJOBARN_BINDING);
            protocolMarshaller.marshall(processingJob.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

