/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.ContainerMode;
import com.amazonaws.services.sagemaker.model.ImageConfig;
import com.amazonaws.services.sagemaker.model.transform.ContainerDefinitionMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ContainerDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String containerHostname;
    private String image;
    private ImageConfig imageConfig;
    private String mode;
    private String modelDataUrl;
    private Map<String, String> environment;
    private String modelPackageName;

    public void setContainerHostname(String containerHostname) {
        this.containerHostname = containerHostname;
    }

    public String getContainerHostname() {
        return this.containerHostname;
    }

    public ContainerDefinition withContainerHostname(String containerHostname) {
        this.setContainerHostname(containerHostname);
        return this;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public ContainerDefinition withImage(String image) {
        this.setImage(image);
        return this;
    }

    public void setImageConfig(ImageConfig imageConfig) {
        this.imageConfig = imageConfig;
    }

    public ImageConfig getImageConfig() {
        return this.imageConfig;
    }

    public ContainerDefinition withImageConfig(ImageConfig imageConfig) {
        this.setImageConfig(imageConfig);
        return this;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public ContainerDefinition withMode(String mode) {
        this.setMode(mode);
        return this;
    }

    public ContainerDefinition withMode(ContainerMode mode) {
        this.mode = mode.toString();
        return this;
    }

    public void setModelDataUrl(String modelDataUrl) {
        this.modelDataUrl = modelDataUrl;
    }

    public String getModelDataUrl() {
        return this.modelDataUrl;
    }

    public ContainerDefinition withModelDataUrl(String modelDataUrl) {
        this.setModelDataUrl(modelDataUrl);
        return this;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public ContainerDefinition withEnvironment(Map<String, String> environment) {
        this.setEnvironment(environment);
        return this;
    }

    public ContainerDefinition addEnvironmentEntry(String key, String value) {
        if (null == this.environment) {
            this.environment = new HashMap<String, String>();
        }
        if (this.environment.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.environment.put(key, value);
        return this;
    }

    public ContainerDefinition clearEnvironmentEntries() {
        this.environment = null;
        return this;
    }

    public void setModelPackageName(String modelPackageName) {
        this.modelPackageName = modelPackageName;
    }

    public String getModelPackageName() {
        return this.modelPackageName;
    }

    public ContainerDefinition withModelPackageName(String modelPackageName) {
        this.setModelPackageName(modelPackageName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerHostname() != null) {
            sb.append("ContainerHostname: ").append(this.getContainerHostname()).append(",");
        }
        if (this.getImage() != null) {
            sb.append("Image: ").append(this.getImage()).append(",");
        }
        if (this.getImageConfig() != null) {
            sb.append("ImageConfig: ").append(this.getImageConfig()).append(",");
        }
        if (this.getMode() != null) {
            sb.append("Mode: ").append(this.getMode()).append(",");
        }
        if (this.getModelDataUrl() != null) {
            sb.append("ModelDataUrl: ").append(this.getModelDataUrl()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getModelPackageName() != null) {
            sb.append("ModelPackageName: ").append(this.getModelPackageName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDefinition)) {
            return false;
        }
        ContainerDefinition other = (ContainerDefinition)obj;
        if (other.getContainerHostname() == null ^ this.getContainerHostname() == null) {
            return false;
        }
        if (other.getContainerHostname() != null && !other.getContainerHostname().equals(this.getContainerHostname())) {
            return false;
        }
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getImageConfig() == null ^ this.getImageConfig() == null) {
            return false;
        }
        if (other.getImageConfig() != null && !other.getImageConfig().equals(this.getImageConfig())) {
            return false;
        }
        if (other.getMode() == null ^ this.getMode() == null) {
            return false;
        }
        if (other.getMode() != null && !other.getMode().equals(this.getMode())) {
            return false;
        }
        if (other.getModelDataUrl() == null ^ this.getModelDataUrl() == null) {
            return false;
        }
        if (other.getModelDataUrl() != null && !other.getModelDataUrl().equals(this.getModelDataUrl())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getModelPackageName() == null ^ this.getModelPackageName() == null) {
            return false;
        }
        return other.getModelPackageName() == null || other.getModelPackageName().equals(this.getModelPackageName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerHostname() == null ? 0 : this.getContainerHostname().hashCode());
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getImageConfig() == null ? 0 : this.getImageConfig().hashCode());
        hashCode = 31 * hashCode + (this.getMode() == null ? 0 : this.getMode().hashCode());
        hashCode = 31 * hashCode + (this.getModelDataUrl() == null ? 0 : this.getModelDataUrl().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getModelPackageName() == null ? 0 : this.getModelPackageName().hashCode());
        return hashCode;
    }

    public ContainerDefinition clone() {
        try {
            return (ContainerDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

