/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.ObjectLambdaConfiguration;
import com.amazonaws.services.s3control.model.ObjectLambdaTransformationConfiguration;
import com.amazonaws.services.s3control.model.transform.ObjectLambdaTransformationConfigurationStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ObjectLambdaConfigurationStaxUnmarshaller
implements Unmarshaller<ObjectLambdaConfiguration, StaxUnmarshallerContext> {
    private static ObjectLambdaConfigurationStaxUnmarshaller instance;

    public ObjectLambdaConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        ObjectLambdaConfiguration objectLambdaConfiguration = new ObjectLambdaConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return objectLambdaConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SupportingAccessPoint", targetDepth)) {
                    objectLambdaConfiguration.setSupportingAccessPoint(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CloudWatchMetricsEnabled", targetDepth)) {
                    objectLambdaConfiguration.setCloudWatchMetricsEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AllowedFeatures", targetDepth)) {
                    objectLambdaConfiguration.withAllowedFeatures(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("AllowedFeatures/AllowedFeature", targetDepth)) {
                    objectLambdaConfiguration.withAllowedFeatures(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TransformationConfigurations", targetDepth)) {
                    objectLambdaConfiguration.withTransformationConfigurations(new ArrayList<ObjectLambdaTransformationConfiguration>());
                    continue;
                }
                if (!context.testExpression("TransformationConfigurations/TransformationConfiguration", targetDepth)) continue;
                objectLambdaConfiguration.withTransformationConfigurations(ObjectLambdaTransformationConfigurationStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return objectLambdaConfiguration;
    }

    public static ObjectLambdaConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ObjectLambdaConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

