/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.GetBucketRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class GetBucketRequestMarshaller
implements Marshaller<Request<GetBucketRequest>, GetBucketRequest> {
    public Request<GetBucketRequest> marshall(GetBucketRequest getBucketRequest) {
        if (getBucketRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getBucketRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.GET);
        if (getBucketRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)getBucketRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/bucket/{name}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", getBucketRequest.getBucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

