/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.GetAccessPointResult;
import com.amazonaws.services.s3control.model.transform.PublicAccessBlockConfigurationStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.VpcConfigurationStaxUnmarshaller;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;

public class GetAccessPointResultStaxUnmarshaller
implements Unmarshaller<GetAccessPointResult, StaxUnmarshallerContext> {
    private static GetAccessPointResultStaxUnmarshaller instance;

    public GetAccessPointResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        GetAccessPointResult getAccessPointResult = new GetAccessPointResult();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return getAccessPointResult;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    getAccessPointResult.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Bucket", targetDepth)) {
                    getAccessPointResult.setBucket(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NetworkOrigin", targetDepth)) {
                    getAccessPointResult.setNetworkOrigin(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VpcConfiguration", targetDepth)) {
                    getAccessPointResult.setVpcConfiguration(VpcConfigurationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PublicAccessBlockConfiguration", targetDepth)) {
                    getAccessPointResult.setPublicAccessBlockConfiguration(PublicAccessBlockConfigurationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    getAccessPointResult.setCreationDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("Alias", targetDepth)) {
                    getAccessPointResult.setAlias(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AccessPointArn", targetDepth)) {
                    getAccessPointResult.setAccessPointArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Endpoints/entry", targetDepth)) continue;
                Map.Entry<String, String> entry = EndpointsMapEntryUnmarshaller.getInstance().unmarshall(context);
                getAccessPointResult.addEndpointsEntry(entry.getKey(), entry.getValue());
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return getAccessPointResult;
    }

    public static GetAccessPointResultStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new GetAccessPointResultStaxUnmarshaller();
        }
        return instance;
    }

    private static class EndpointsMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static EndpointsMapEntryUnmarshaller instance;

        private EndpointsMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static EndpointsMapEntryUnmarshaller getInstance() {
            if (instance == null) {
                instance = new EndpointsMapEntryUnmarshaller();
            }
            return instance;
        }
    }
}

