/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.arn.Arn;
import com.amazonaws.arn.ArnConverter;
import com.amazonaws.arn.ArnResource;
import com.amazonaws.services.s3.S3AccessPointResource;
import com.amazonaws.services.s3.S3ArnUtils;
import com.amazonaws.services.s3.S3Resource;
import com.amazonaws.services.s3.internal.IntermediateOutpostResource;
import com.amazonaws.services.s3.internal.OutpostResourceType;
import com.amazonaws.services.s3.internal.S3OutpostResource;
import com.amazonaws.services.s3control.internal.S3ControlBucketResource;
import com.amazonaws.services.s3control.internal.S3ControlResourceType;

@SdkInternalApi
public final class S3ControlArnConverter
implements ArnConverter<S3Resource> {
    private static final S3ControlArnConverter INSTANCE = new S3ControlArnConverter();

    private S3ControlArnConverter() {
    }

    public static S3ControlArnConverter getInstance() {
        return INSTANCE;
    }

    public S3Resource convertArn(Arn arn) {
        S3ControlResourceType s3ResourceType;
        try {
            s3ResourceType = S3ControlResourceType.fromValue(arn.getResource().getResourceType());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown ARN type '" + arn.getResource().getResourceType() + "'");
        }
        switch (s3ResourceType) {
            case OUTPOST: {
                return this.parseS3OutpostArn(arn);
            }
        }
        throw new IllegalArgumentException("Unknown ARN type '" + arn.getResource().getResourceType() + "'");
    }

    private S3Resource parseS3OutpostArn(Arn arn) {
        OutpostResourceType outpostResourceType;
        IntermediateOutpostResource intermediateOutpostResource = S3ArnUtils.parseOutpostArn((Arn)arn);
        ArnResource outpostSubresource = intermediateOutpostResource.getOutpostSubresource();
        String subResource = outpostSubresource.getResource();
        try {
            outpostResourceType = OutpostResourceType.fromValue((String)outpostSubresource.getResourceType());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown outpost ARN type '" + outpostSubresource.getResourceType() + "'");
        }
        String outpostId = intermediateOutpostResource.getOutpostId();
        switch (outpostResourceType) {
            case OUTPOST_BUCKET: {
                return S3ControlBucketResource.builder().withBucketName(subResource).withParentS3Resource((S3Resource)S3OutpostResource.builder().withPartition(arn.getPartition()).withRegion(arn.getRegion()).withAccountId(arn.getAccountId()).withOutpostId(outpostId).build()).build();
            }
            case OUTPOST_ACCESS_POINT: {
                return S3AccessPointResource.builder().withAccessPointName(subResource).withParentS3Resource((S3Resource)S3OutpostResource.builder().withPartition(arn.getPartition()).withRegion(arn.getRegion()).withAccountId(arn.getAccountId()).withOutpostId(outpostId).build()).build();
            }
        }
        throw new IllegalArgumentException("Unknown outpost ARN type '" + outpostSubresource.getResourceType() + "'");
    }
}

