/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.AbortIncompleteMultipartUpload;
import com.amazonaws.services.s3control.model.LifecycleConfiguration;
import com.amazonaws.services.s3control.model.LifecycleExpiration;
import com.amazonaws.services.s3control.model.LifecycleRule;
import com.amazonaws.services.s3control.model.LifecycleRuleAndOperator;
import com.amazonaws.services.s3control.model.LifecycleRuleFilter;
import com.amazonaws.services.s3control.model.NoncurrentVersionExpiration;
import com.amazonaws.services.s3control.model.NoncurrentVersionTransition;
import com.amazonaws.services.s3control.model.PutBucketLifecycleConfigurationRequest;
import com.amazonaws.services.s3control.model.S3Tag;
import com.amazonaws.services.s3control.model.Transition;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class PutBucketLifecycleConfigurationRequestMarshaller
implements Marshaller<Request<PutBucketLifecycleConfigurationRequest>, PutBucketLifecycleConfigurationRequest> {
    public Request<PutBucketLifecycleConfigurationRequest> marshall(PutBucketLifecycleConfigurationRequest putBucketLifecycleConfigurationRequest) {
        if (putBucketLifecycleConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketLifecycleConfigurationRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketLifecycleConfigurationRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)putBucketLifecycleConfigurationRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/bucket/{name}/lifecycleconfiguration";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", putBucketLifecycleConfigurationRequest.getBucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            LifecycleConfiguration lifecycleConfiguration = putBucketLifecycleConfigurationRequest.getLifecycleConfiguration();
            if (lifecycleConfiguration != null) {
                xmlWriter.startElement("LifecycleConfiguration");
                List<LifecycleRule> lifecycleConfigurationRulesList = lifecycleConfiguration.getRules();
                if (lifecycleConfigurationRulesList != null) {
                    xmlWriter.startElement("Rules");
                    for (LifecycleRule lifecycleConfigurationRulesListValue : lifecycleConfigurationRulesList) {
                        AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;
                        NoncurrentVersionExpiration noncurrentVersionExpiration;
                        List<NoncurrentVersionTransition> lifecycleRuleNoncurrentVersionTransitionsList;
                        List<Transition> lifecycleRuleTransitionsList;
                        Object and;
                        LifecycleRuleFilter filter;
                        xmlWriter.startElement("Rule");
                        LifecycleExpiration expiration = lifecycleConfigurationRulesListValue.getExpiration();
                        if (expiration != null) {
                            xmlWriter.startElement("Expiration");
                            if (expiration.getDate() != null) {
                                xmlWriter.startElement("Date").value(expiration.getDate()).endElement();
                            }
                            if (expiration.getDays() != null) {
                                xmlWriter.startElement("Days").value((Object)expiration.getDays()).endElement();
                            }
                            if (expiration.getExpiredObjectDeleteMarker() != null) {
                                xmlWriter.startElement("ExpiredObjectDeleteMarker").value((Object)expiration.getExpiredObjectDeleteMarker()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (lifecycleConfigurationRulesListValue.getID() != null) {
                            xmlWriter.startElement("ID").value(lifecycleConfigurationRulesListValue.getID()).endElement();
                        }
                        if ((filter = lifecycleConfigurationRulesListValue.getFilter()) != null) {
                            S3Tag tag;
                            xmlWriter.startElement("Filter");
                            if (filter.getPrefix() != null) {
                                xmlWriter.startElement("Prefix").value(filter.getPrefix()).endElement();
                            }
                            if ((tag = filter.getTag()) != null) {
                                xmlWriter.startElement("Tag");
                                if (tag.getKey() != null) {
                                    xmlWriter.startElement("Key").value(tag.getKey()).endElement();
                                }
                                if (tag.getValue() != null) {
                                    xmlWriter.startElement("Value").value(tag.getValue()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((and = filter.getAnd()) != null) {
                                List<S3Tag> lifecycleRuleAndOperatorTagsList;
                                xmlWriter.startElement("And");
                                if (((LifecycleRuleAndOperator)and).getPrefix() != null) {
                                    xmlWriter.startElement("Prefix").value(((LifecycleRuleAndOperator)and).getPrefix()).endElement();
                                }
                                if ((lifecycleRuleAndOperatorTagsList = ((LifecycleRuleAndOperator)and).getTags()) != null) {
                                    xmlWriter.startElement("Tags");
                                    for (S3Tag lifecycleRuleAndOperatorTagsListValue : lifecycleRuleAndOperatorTagsList) {
                                        xmlWriter.startElement("member");
                                        if (lifecycleRuleAndOperatorTagsListValue.getKey() != null) {
                                            xmlWriter.startElement("Key").value(lifecycleRuleAndOperatorTagsListValue.getKey()).endElement();
                                        }
                                        if (lifecycleRuleAndOperatorTagsListValue.getValue() != null) {
                                            xmlWriter.startElement("Value").value(lifecycleRuleAndOperatorTagsListValue.getValue()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (lifecycleConfigurationRulesListValue.getStatus() != null) {
                            xmlWriter.startElement("Status").value(lifecycleConfigurationRulesListValue.getStatus()).endElement();
                        }
                        if ((lifecycleRuleTransitionsList = lifecycleConfigurationRulesListValue.getTransitions()) != null) {
                            xmlWriter.startElement("Transitions");
                            and = lifecycleRuleTransitionsList.iterator();
                            while (and.hasNext()) {
                                Transition lifecycleRuleTransitionsListValue = (Transition)and.next();
                                xmlWriter.startElement("Transition");
                                if (lifecycleRuleTransitionsListValue.getDate() != null) {
                                    xmlWriter.startElement("Date").value(lifecycleRuleTransitionsListValue.getDate()).endElement();
                                }
                                if (lifecycleRuleTransitionsListValue.getDays() != null) {
                                    xmlWriter.startElement("Days").value((Object)lifecycleRuleTransitionsListValue.getDays()).endElement();
                                }
                                if (lifecycleRuleTransitionsListValue.getStorageClass() != null) {
                                    xmlWriter.startElement("StorageClass").value(lifecycleRuleTransitionsListValue.getStorageClass()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((lifecycleRuleNoncurrentVersionTransitionsList = lifecycleConfigurationRulesListValue.getNoncurrentVersionTransitions()) != null) {
                            xmlWriter.startElement("NoncurrentVersionTransitions");
                            for (NoncurrentVersionTransition lifecycleRuleNoncurrentVersionTransitionsListValue : lifecycleRuleNoncurrentVersionTransitionsList) {
                                xmlWriter.startElement("NoncurrentVersionTransition");
                                if (lifecycleRuleNoncurrentVersionTransitionsListValue.getNoncurrentDays() != null) {
                                    xmlWriter.startElement("NoncurrentDays").value((Object)lifecycleRuleNoncurrentVersionTransitionsListValue.getNoncurrentDays()).endElement();
                                }
                                if (lifecycleRuleNoncurrentVersionTransitionsListValue.getStorageClass() != null) {
                                    xmlWriter.startElement("StorageClass").value(lifecycleRuleNoncurrentVersionTransitionsListValue.getStorageClass()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((noncurrentVersionExpiration = lifecycleConfigurationRulesListValue.getNoncurrentVersionExpiration()) != null) {
                            xmlWriter.startElement("NoncurrentVersionExpiration");
                            if (noncurrentVersionExpiration.getNoncurrentDays() != null) {
                                xmlWriter.startElement("NoncurrentDays").value((Object)noncurrentVersionExpiration.getNoncurrentDays()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((abortIncompleteMultipartUpload = lifecycleConfigurationRulesListValue.getAbortIncompleteMultipartUpload()) != null) {
                            xmlWriter.startElement("AbortIncompleteMultipartUpload");
                            if (abortIncompleteMultipartUpload.getDaysAfterInitiation() != null) {
                                xmlWriter.startElement("DaysAfterInitiation").value((Object)abortIncompleteMultipartUpload.getDaysAfterInitiation()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

