/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.TargetObjectKeyFormat;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.ExpectedBucketOwnerRequest;
import java.io.Serializable;

public class SetBucketLoggingConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
ExpectedBucketOwnerRequest {
    private String bucketName;
    private BucketLoggingConfiguration loggingConfiguration;
    private String expectedBucketOwner;
    private TargetObjectKeyFormat targetObjectKeyFormat;

    public SetBucketLoggingConfigurationRequest(String bucketName, BucketLoggingConfiguration loggingConfiguration) {
        this.bucketName = bucketName;
        this.loggingConfiguration = loggingConfiguration;
        this.targetObjectKeyFormat = loggingConfiguration.getTargetObjectKeyFormat();
    }

    @Override
    public String getExpectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    @Override
    public SetBucketLoggingConfigurationRequest withExpectedBucketOwner(String expectedBucketOwner) {
        this.expectedBucketOwner = expectedBucketOwner;
        return this;
    }

    @Override
    public void setExpectedBucketOwner(String expectedBucketOwner) {
        this.withExpectedBucketOwner(expectedBucketOwner);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public SetBucketLoggingConfigurationRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public BucketLoggingConfiguration getLoggingConfiguration() {
        return this.loggingConfiguration;
    }

    public void setLoggingConfiguration(BucketLoggingConfiguration loggingConfiguration) {
        this.loggingConfiguration = loggingConfiguration;
    }

    public SetBucketLoggingConfigurationRequest withLoggingConfiguration(BucketLoggingConfiguration loggingConfiguration) {
        this.setLoggingConfiguration(loggingConfiguration);
        return this;
    }

    public TargetObjectKeyFormat getTargetObjectKeyFormat() {
        return this.targetObjectKeyFormat;
    }

    public void setTargetObjectKeyFormat(TargetObjectKeyFormat targetObjectKeyFormat) {
        this.targetObjectKeyFormat = targetObjectKeyFormat;
    }

    public SetBucketLoggingConfigurationRequest withTargetObjectKeyFormat(TargetObjectKeyFormat targetObjectKeyFormat) {
        this.setTargetObjectKeyFormat(targetObjectKeyFormat);
        return this;
    }
}

