/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53resolver.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.route53resolver.model.TargetAddress;
import com.amazonaws.services.route53resolver.model.transform.ResolverRuleConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResolverRuleConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<TargetAddress> targetIps;
    private String resolverEndpointId;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ResolverRuleConfig withName(String name) {
        this.setName(name);
        return this;
    }

    public List<TargetAddress> getTargetIps() {
        return this.targetIps;
    }

    public void setTargetIps(Collection<TargetAddress> targetIps) {
        if (targetIps == null) {
            this.targetIps = null;
            return;
        }
        this.targetIps = new ArrayList<TargetAddress>(targetIps);
    }

    public ResolverRuleConfig withTargetIps(TargetAddress ... targetIps) {
        if (this.targetIps == null) {
            this.setTargetIps(new ArrayList<TargetAddress>(targetIps.length));
        }
        for (TargetAddress ele : targetIps) {
            this.targetIps.add(ele);
        }
        return this;
    }

    public ResolverRuleConfig withTargetIps(Collection<TargetAddress> targetIps) {
        this.setTargetIps(targetIps);
        return this;
    }

    public void setResolverEndpointId(String resolverEndpointId) {
        this.resolverEndpointId = resolverEndpointId;
    }

    public String getResolverEndpointId() {
        return this.resolverEndpointId;
    }

    public ResolverRuleConfig withResolverEndpointId(String resolverEndpointId) {
        this.setResolverEndpointId(resolverEndpointId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTargetIps() != null) {
            sb.append("TargetIps: ").append(this.getTargetIps()).append(",");
        }
        if (this.getResolverEndpointId() != null) {
            sb.append("ResolverEndpointId: ").append(this.getResolverEndpointId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolverRuleConfig)) {
            return false;
        }
        ResolverRuleConfig other = (ResolverRuleConfig)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTargetIps() == null ^ this.getTargetIps() == null) {
            return false;
        }
        if (other.getTargetIps() != null && !other.getTargetIps().equals(this.getTargetIps())) {
            return false;
        }
        if (other.getResolverEndpointId() == null ^ this.getResolverEndpointId() == null) {
            return false;
        }
        return other.getResolverEndpointId() == null || other.getResolverEndpointId().equals(this.getResolverEndpointId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTargetIps() == null ? 0 : this.getTargetIps().hashCode());
        hashCode = 31 * hashCode + (this.getResolverEndpointId() == null ? 0 : this.getResolverEndpointId().hashCode());
        return hashCode;
    }

    public ResolverRuleConfig clone() {
        try {
            return (ResolverRuleConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResolverRuleConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

