/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoveryreadiness.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.route53recoveryreadiness.model.CellOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListCellsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<CellOutput> cells;
    private String nextToken;

    public List<CellOutput> getCells() {
        return this.cells;
    }

    public void setCells(Collection<CellOutput> cells) {
        if (cells == null) {
            this.cells = null;
            return;
        }
        this.cells = new ArrayList<CellOutput>(cells);
    }

    public ListCellsResult withCells(CellOutput ... cells) {
        if (this.cells == null) {
            this.setCells(new ArrayList<CellOutput>(cells.length));
        }
        for (CellOutput ele : cells) {
            this.cells.add(ele);
        }
        return this;
    }

    public ListCellsResult withCells(Collection<CellOutput> cells) {
        this.setCells(cells);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCellsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCells() != null) {
            sb.append("Cells: ").append(this.getCells()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCellsResult)) {
            return false;
        }
        ListCellsResult other = (ListCellsResult)obj;
        if (other.getCells() == null ^ this.getCells() == null) {
            return false;
        }
        if (other.getCells() != null && !other.getCells().equals(this.getCells())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCells() == null ? 0 : this.getCells().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListCellsResult clone() {
        try {
            return (ListCellsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

