/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoveryreadiness.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.route53recoveryreadiness.model.transform.CellOutputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CellOutput
implements Serializable,
Cloneable,
StructuredPojo {
    private String cellArn;
    private String cellName;
    private List<String> cells;
    private List<String> parentReadinessScopes;
    private Map<String, String> tags;

    public void setCellArn(String cellArn) {
        this.cellArn = cellArn;
    }

    public String getCellArn() {
        return this.cellArn;
    }

    public CellOutput withCellArn(String cellArn) {
        this.setCellArn(cellArn);
        return this;
    }

    public void setCellName(String cellName) {
        this.cellName = cellName;
    }

    public String getCellName() {
        return this.cellName;
    }

    public CellOutput withCellName(String cellName) {
        this.setCellName(cellName);
        return this;
    }

    public List<String> getCells() {
        return this.cells;
    }

    public void setCells(Collection<String> cells) {
        if (cells == null) {
            this.cells = null;
            return;
        }
        this.cells = new ArrayList<String>(cells);
    }

    public CellOutput withCells(String ... cells) {
        if (this.cells == null) {
            this.setCells(new ArrayList<String>(cells.length));
        }
        for (String ele : cells) {
            this.cells.add(ele);
        }
        return this;
    }

    public CellOutput withCells(Collection<String> cells) {
        this.setCells(cells);
        return this;
    }

    public List<String> getParentReadinessScopes() {
        return this.parentReadinessScopes;
    }

    public void setParentReadinessScopes(Collection<String> parentReadinessScopes) {
        if (parentReadinessScopes == null) {
            this.parentReadinessScopes = null;
            return;
        }
        this.parentReadinessScopes = new ArrayList<String>(parentReadinessScopes);
    }

    public CellOutput withParentReadinessScopes(String ... parentReadinessScopes) {
        if (this.parentReadinessScopes == null) {
            this.setParentReadinessScopes(new ArrayList<String>(parentReadinessScopes.length));
        }
        for (String ele : parentReadinessScopes) {
            this.parentReadinessScopes.add(ele);
        }
        return this;
    }

    public CellOutput withParentReadinessScopes(Collection<String> parentReadinessScopes) {
        this.setParentReadinessScopes(parentReadinessScopes);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CellOutput withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CellOutput addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CellOutput clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCellArn() != null) {
            sb.append("CellArn: ").append(this.getCellArn()).append(",");
        }
        if (this.getCellName() != null) {
            sb.append("CellName: ").append(this.getCellName()).append(",");
        }
        if (this.getCells() != null) {
            sb.append("Cells: ").append(this.getCells()).append(",");
        }
        if (this.getParentReadinessScopes() != null) {
            sb.append("ParentReadinessScopes: ").append(this.getParentReadinessScopes()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CellOutput)) {
            return false;
        }
        CellOutput other = (CellOutput)obj;
        if (other.getCellArn() == null ^ this.getCellArn() == null) {
            return false;
        }
        if (other.getCellArn() != null && !other.getCellArn().equals(this.getCellArn())) {
            return false;
        }
        if (other.getCellName() == null ^ this.getCellName() == null) {
            return false;
        }
        if (other.getCellName() != null && !other.getCellName().equals(this.getCellName())) {
            return false;
        }
        if (other.getCells() == null ^ this.getCells() == null) {
            return false;
        }
        if (other.getCells() != null && !other.getCells().equals(this.getCells())) {
            return false;
        }
        if (other.getParentReadinessScopes() == null ^ this.getParentReadinessScopes() == null) {
            return false;
        }
        if (other.getParentReadinessScopes() != null && !other.getParentReadinessScopes().equals(this.getParentReadinessScopes())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCellArn() == null ? 0 : this.getCellArn().hashCode());
        hashCode = 31 * hashCode + (this.getCellName() == null ? 0 : this.getCellName().hashCode());
        hashCode = 31 * hashCode + (this.getCells() == null ? 0 : this.getCells().hashCode());
        hashCode = 31 * hashCode + (this.getParentReadinessScopes() == null ? 0 : this.getParentReadinessScopes().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CellOutput clone() {
        try {
            return (CellOutput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CellOutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

