/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53domains.model.UpdateDomainContactRequest;
import com.amazonaws.services.route53domains.model.transform.ContactDetailJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateDomainContactRequestMarshaller
implements Marshaller<Request<UpdateDomainContactRequest>, UpdateDomainContactRequest> {
    public Request<UpdateDomainContactRequest> marshall(UpdateDomainContactRequest updateDomainContactRequest) {
        if (updateDomainContactRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateDomainContactRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.UpdateDomainContact");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (updateDomainContactRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(updateDomainContactRequest.getDomainName());
            }
            if (updateDomainContactRequest.getAdminContact() != null) {
                jsonGenerator.writeFieldName("AdminContact");
                ContactDetailJsonMarshaller.getInstance().marshall(updateDomainContactRequest.getAdminContact(), jsonGenerator);
            }
            if (updateDomainContactRequest.getRegistrantContact() != null) {
                jsonGenerator.writeFieldName("RegistrantContact");
                ContactDetailJsonMarshaller.getInstance().marshall(updateDomainContactRequest.getRegistrantContact(), jsonGenerator);
            }
            if (updateDomainContactRequest.getTechContact() != null) {
                jsonGenerator.writeFieldName("TechContact");
                ContactDetailJsonMarshaller.getInstance().marshall(updateDomainContactRequest.getTechContact(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

