/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.transform.ConnectedHomeSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConnectedHomeSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> labels;
    private Float minConfidence;

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(Collection<String> labels) {
        if (labels == null) {
            this.labels = null;
            return;
        }
        this.labels = new ArrayList<String>(labels);
    }

    public ConnectedHomeSettings withLabels(String ... labels) {
        if (this.labels == null) {
            this.setLabels(new ArrayList<String>(labels.length));
        }
        for (String ele : labels) {
            this.labels.add(ele);
        }
        return this;
    }

    public ConnectedHomeSettings withLabels(Collection<String> labels) {
        this.setLabels(labels);
        return this;
    }

    public void setMinConfidence(Float minConfidence) {
        this.minConfidence = minConfidence;
    }

    public Float getMinConfidence() {
        return this.minConfidence;
    }

    public ConnectedHomeSettings withMinConfidence(Float minConfidence) {
        this.setMinConfidence(minConfidence);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLabels() != null) {
            sb.append("Labels: ").append(this.getLabels()).append(",");
        }
        if (this.getMinConfidence() != null) {
            sb.append("MinConfidence: ").append(this.getMinConfidence());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectedHomeSettings)) {
            return false;
        }
        ConnectedHomeSettings other = (ConnectedHomeSettings)obj;
        if (other.getLabels() == null ^ this.getLabels() == null) {
            return false;
        }
        if (other.getLabels() != null && !other.getLabels().equals(this.getLabels())) {
            return false;
        }
        if (other.getMinConfidence() == null ^ this.getMinConfidence() == null) {
            return false;
        }
        return other.getMinConfidence() == null || other.getMinConfidence().equals(this.getMinConfidence());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLabels() == null ? 0 : this.getLabels().hashCode());
        hashCode = 31 * hashCode + (this.getMinConfidence() == null ? 0 : this.getMinConfidence().hashCode());
        return hashCode;
    }

    public ConnectedHomeSettings clone() {
        try {
            return (ConnectedHomeSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectedHomeSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

