/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.transform.OutputConfigMarshaller;
import java.io.Serializable;

public class OutputConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3Bucket;
    private String s3KeyPrefix;

    public void setS3Bucket(String s3Bucket) {
        this.s3Bucket = s3Bucket;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public OutputConfig withS3Bucket(String s3Bucket) {
        this.setS3Bucket(s3Bucket);
        return this;
    }

    public void setS3KeyPrefix(String s3KeyPrefix) {
        this.s3KeyPrefix = s3KeyPrefix;
    }

    public String getS3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public OutputConfig withS3KeyPrefix(String s3KeyPrefix) {
        this.setS3KeyPrefix(s3KeyPrefix);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.getS3Bucket()).append(",");
        }
        if (this.getS3KeyPrefix() != null) {
            sb.append("S3KeyPrefix: ").append(this.getS3KeyPrefix());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputConfig)) {
            return false;
        }
        OutputConfig other = (OutputConfig)obj;
        if (other.getS3Bucket() == null ^ this.getS3Bucket() == null) {
            return false;
        }
        if (other.getS3Bucket() != null && !other.getS3Bucket().equals(this.getS3Bucket())) {
            return false;
        }
        if (other.getS3KeyPrefix() == null ^ this.getS3KeyPrefix() == null) {
            return false;
        }
        return other.getS3KeyPrefix() == null || other.getS3KeyPrefix().equals(this.getS3KeyPrefix());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Bucket() == null ? 0 : this.getS3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.getS3KeyPrefix() == null ? 0 : this.getS3KeyPrefix().hashCode());
        return hashCode;
    }

    public OutputConfig clone() {
        try {
            return (OutputConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

