/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.ActionType;
import com.amazonaws.services.redshift.model.NodeConfigurationOptionsFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeNodeConfigurationOptionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String actionType;
    private String clusterIdentifier;
    private String snapshotIdentifier;
    private String snapshotArn;
    private String ownerAccount;
    private SdkInternalList<NodeConfigurationOptionsFilter> filters;
    private String marker;
    private Integer maxRecords;

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String getActionType() {
        return this.actionType;
    }

    public DescribeNodeConfigurationOptionsRequest withActionType(String actionType) {
        this.setActionType(actionType);
        return this;
    }

    public DescribeNodeConfigurationOptionsRequest withActionType(ActionType actionType) {
        this.actionType = actionType.toString();
        return this;
    }

    public void setClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
    }

    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    public DescribeNodeConfigurationOptionsRequest withClusterIdentifier(String clusterIdentifier) {
        this.setClusterIdentifier(clusterIdentifier);
        return this;
    }

    public void setSnapshotIdentifier(String snapshotIdentifier) {
        this.snapshotIdentifier = snapshotIdentifier;
    }

    public String getSnapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public DescribeNodeConfigurationOptionsRequest withSnapshotIdentifier(String snapshotIdentifier) {
        this.setSnapshotIdentifier(snapshotIdentifier);
        return this;
    }

    public void setSnapshotArn(String snapshotArn) {
        this.snapshotArn = snapshotArn;
    }

    public String getSnapshotArn() {
        return this.snapshotArn;
    }

    public DescribeNodeConfigurationOptionsRequest withSnapshotArn(String snapshotArn) {
        this.setSnapshotArn(snapshotArn);
        return this;
    }

    public void setOwnerAccount(String ownerAccount) {
        this.ownerAccount = ownerAccount;
    }

    public String getOwnerAccount() {
        return this.ownerAccount;
    }

    public DescribeNodeConfigurationOptionsRequest withOwnerAccount(String ownerAccount) {
        this.setOwnerAccount(ownerAccount);
        return this;
    }

    public List<NodeConfigurationOptionsFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<NodeConfigurationOptionsFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList(filters);
    }

    public DescribeNodeConfigurationOptionsRequest withFilters(NodeConfigurationOptionsFilter ... filters) {
        if (this.filters == null) {
            this.setFilters((Collection<NodeConfigurationOptionsFilter>)new SdkInternalList(filters.length));
        }
        for (NodeConfigurationOptionsFilter ele : filters) {
            this.filters.add((Object)ele);
        }
        return this;
    }

    public DescribeNodeConfigurationOptionsRequest withFilters(Collection<NodeConfigurationOptionsFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeNodeConfigurationOptionsRequest withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public void setMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
    }

    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    public DescribeNodeConfigurationOptionsRequest withMaxRecords(Integer maxRecords) {
        this.setMaxRecords(maxRecords);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActionType() != null) {
            sb.append("ActionType: ").append(this.getActionType()).append(",");
        }
        if (this.getClusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.getClusterIdentifier()).append(",");
        }
        if (this.getSnapshotIdentifier() != null) {
            sb.append("SnapshotIdentifier: ").append(this.getSnapshotIdentifier()).append(",");
        }
        if (this.getSnapshotArn() != null) {
            sb.append("SnapshotArn: ").append(this.getSnapshotArn()).append(",");
        }
        if (this.getOwnerAccount() != null) {
            sb.append("OwnerAccount: ").append(this.getOwnerAccount()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker()).append(",");
        }
        if (this.getMaxRecords() != null) {
            sb.append("MaxRecords: ").append(this.getMaxRecords());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNodeConfigurationOptionsRequest)) {
            return false;
        }
        DescribeNodeConfigurationOptionsRequest other = (DescribeNodeConfigurationOptionsRequest)obj;
        if (other.getActionType() == null ^ this.getActionType() == null) {
            return false;
        }
        if (other.getActionType() != null && !other.getActionType().equals(this.getActionType())) {
            return false;
        }
        if (other.getClusterIdentifier() == null ^ this.getClusterIdentifier() == null) {
            return false;
        }
        if (other.getClusterIdentifier() != null && !other.getClusterIdentifier().equals(this.getClusterIdentifier())) {
            return false;
        }
        if (other.getSnapshotIdentifier() == null ^ this.getSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getSnapshotIdentifier() != null && !other.getSnapshotIdentifier().equals(this.getSnapshotIdentifier())) {
            return false;
        }
        if (other.getSnapshotArn() == null ^ this.getSnapshotArn() == null) {
            return false;
        }
        if (other.getSnapshotArn() != null && !other.getSnapshotArn().equals(this.getSnapshotArn())) {
            return false;
        }
        if (other.getOwnerAccount() == null ^ this.getOwnerAccount() == null) {
            return false;
        }
        if (other.getOwnerAccount() != null && !other.getOwnerAccount().equals(this.getOwnerAccount())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getMaxRecords() == null ^ this.getMaxRecords() == null) {
            return false;
        }
        return other.getMaxRecords() == null || other.getMaxRecords().equals(this.getMaxRecords());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActionType() == null ? 0 : this.getActionType().hashCode());
        hashCode = 31 * hashCode + (this.getClusterIdentifier() == null ? 0 : this.getClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotIdentifier() == null ? 0 : this.getSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotArn() == null ? 0 : this.getSnapshotArn().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerAccount() == null ? 0 : this.getOwnerAccount().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getMaxRecords() == null ? 0 : this.getMaxRecords().hashCode());
        return hashCode;
    }

    public DescribeNodeConfigurationOptionsRequest clone() {
        return (DescribeNodeConfigurationOptionsRequest)super.clone();
    }
}

