/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.redshift.model.ModifyScheduledActionRequest;
import com.amazonaws.services.redshift.model.PauseClusterMessage;
import com.amazonaws.services.redshift.model.ResizeClusterMessage;
import com.amazonaws.services.redshift.model.ResumeClusterMessage;
import com.amazonaws.services.redshift.model.ScheduledActionType;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class ModifyScheduledActionRequestMarshaller
implements Marshaller<Request<ModifyScheduledActionRequest>, ModifyScheduledActionRequest> {
    public Request<ModifyScheduledActionRequest> marshall(ModifyScheduledActionRequest modifyScheduledActionRequest) {
        ScheduledActionType targetAction;
        if (modifyScheduledActionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyScheduledActionRequest, "AmazonRedshift");
        request.addParameter("Action", "ModifyScheduledAction");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyScheduledActionRequest.getScheduledActionName() != null) {
            request.addParameter("ScheduledActionName", StringUtils.fromString((String)modifyScheduledActionRequest.getScheduledActionName()));
        }
        if ((targetAction = modifyScheduledActionRequest.getTargetAction()) != null) {
            ResumeClusterMessage resumeCluster;
            PauseClusterMessage pauseCluster;
            ResizeClusterMessage resizeCluster = targetAction.getResizeCluster();
            if (resizeCluster != null) {
                if (resizeCluster.getClusterIdentifier() != null) {
                    request.addParameter("TargetAction.ResizeCluster.ClusterIdentifier", StringUtils.fromString((String)resizeCluster.getClusterIdentifier()));
                }
                if (resizeCluster.getClusterType() != null) {
                    request.addParameter("TargetAction.ResizeCluster.ClusterType", StringUtils.fromString((String)resizeCluster.getClusterType()));
                }
                if (resizeCluster.getNodeType() != null) {
                    request.addParameter("TargetAction.ResizeCluster.NodeType", StringUtils.fromString((String)resizeCluster.getNodeType()));
                }
                if (resizeCluster.getNumberOfNodes() != null) {
                    request.addParameter("TargetAction.ResizeCluster.NumberOfNodes", StringUtils.fromInteger((Integer)resizeCluster.getNumberOfNodes()));
                }
                if (resizeCluster.getClassic() != null) {
                    request.addParameter("TargetAction.ResizeCluster.Classic", StringUtils.fromBoolean((Boolean)resizeCluster.getClassic()));
                }
            }
            if ((pauseCluster = targetAction.getPauseCluster()) != null && pauseCluster.getClusterIdentifier() != null) {
                request.addParameter("TargetAction.PauseCluster.ClusterIdentifier", StringUtils.fromString((String)pauseCluster.getClusterIdentifier()));
            }
            if ((resumeCluster = targetAction.getResumeCluster()) != null && resumeCluster.getClusterIdentifier() != null) {
                request.addParameter("TargetAction.ResumeCluster.ClusterIdentifier", StringUtils.fromString((String)resumeCluster.getClusterIdentifier()));
            }
        }
        if (modifyScheduledActionRequest.getSchedule() != null) {
            request.addParameter("Schedule", StringUtils.fromString((String)modifyScheduledActionRequest.getSchedule()));
        }
        if (modifyScheduledActionRequest.getIamRole() != null) {
            request.addParameter("IamRole", StringUtils.fromString((String)modifyScheduledActionRequest.getIamRole()));
        }
        if (modifyScheduledActionRequest.getScheduledActionDescription() != null) {
            request.addParameter("ScheduledActionDescription", StringUtils.fromString((String)modifyScheduledActionRequest.getScheduledActionDescription()));
        }
        if (modifyScheduledActionRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)modifyScheduledActionRequest.getStartTime()));
        }
        if (modifyScheduledActionRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)modifyScheduledActionRequest.getEndTime()));
        }
        if (modifyScheduledActionRequest.getEnable() != null) {
            request.addParameter("Enable", StringUtils.fromBoolean((Boolean)modifyScheduledActionRequest.getEnable()));
        }
        return request;
    }
}

