/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RestoreFromClusterSnapshotRequestMarshaller
implements Marshaller<Request<RestoreFromClusterSnapshotRequest>, RestoreFromClusterSnapshotRequest> {
    public Request<RestoreFromClusterSnapshotRequest> marshall(RestoreFromClusterSnapshotRequest restoreFromClusterSnapshotRequest) {
        if (restoreFromClusterSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreFromClusterSnapshotRequest, "AmazonRedshift");
        request.addParameter("Action", "RestoreFromClusterSnapshot");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreFromClusterSnapshotRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getClusterIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.getSnapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getSnapshotIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.getSnapshotClusterIdentifier() != null) {
            request.addParameter("SnapshotClusterIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getSnapshotClusterIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreFromClusterSnapshotRequest.getPort()));
        }
        if (restoreFromClusterSnapshotRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getAvailabilityZone()));
        }
        if (restoreFromClusterSnapshotRequest.getAllowVersionUpgrade() != null) {
            request.addParameter("AllowVersionUpgrade", StringUtils.fromBoolean((Boolean)restoreFromClusterSnapshotRequest.getAllowVersionUpgrade()));
        }
        if (restoreFromClusterSnapshotRequest.getClusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getClusterSubnetGroupName()));
        }
        if (restoreFromClusterSnapshotRequest.getPubliclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)restoreFromClusterSnapshotRequest.getPubliclyAccessible()));
        }
        if (restoreFromClusterSnapshotRequest.getOwnerAccount() != null) {
            request.addParameter("OwnerAccount", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getOwnerAccount()));
        }
        if (restoreFromClusterSnapshotRequest.getHsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getHsmClientCertificateIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.getHsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getHsmConfigurationIdentifier()));
        }
        if (restoreFromClusterSnapshotRequest.getElasticIp() != null) {
            request.addParameter("ElasticIp", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getElasticIp()));
        }
        if (restoreFromClusterSnapshotRequest.getClusterParameterGroupName() != null) {
            request.addParameter("ClusterParameterGroupName", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getClusterParameterGroupName()));
        }
        if (!restoreFromClusterSnapshotRequest.getClusterSecurityGroups().isEmpty() || !((SdkInternalList)restoreFromClusterSnapshotRequest.getClusterSecurityGroups()).isAutoConstruct()) {
            SdkInternalList clusterSecurityGroupsList = (SdkInternalList)restoreFromClusterSnapshotRequest.getClusterSecurityGroups();
            int clusterSecurityGroupsListIndex = 1;
            for (String clusterSecurityGroupsListValue : clusterSecurityGroupsList) {
                if (clusterSecurityGroupsListValue != null) {
                    request.addParameter("ClusterSecurityGroups.ClusterSecurityGroupName." + clusterSecurityGroupsListIndex, StringUtils.fromString((String)clusterSecurityGroupsListValue));
                }
                ++clusterSecurityGroupsListIndex;
            }
        }
        if (!restoreFromClusterSnapshotRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)restoreFromClusterSnapshotRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)restoreFromClusterSnapshotRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (restoreFromClusterSnapshotRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getPreferredMaintenanceWindow()));
        }
        if (restoreFromClusterSnapshotRequest.getAutomatedSnapshotRetentionPeriod() != null) {
            request.addParameter("AutomatedSnapshotRetentionPeriod", StringUtils.fromInteger((Integer)restoreFromClusterSnapshotRequest.getAutomatedSnapshotRetentionPeriod()));
        }
        if (restoreFromClusterSnapshotRequest.getManualSnapshotRetentionPeriod() != null) {
            request.addParameter("ManualSnapshotRetentionPeriod", StringUtils.fromInteger((Integer)restoreFromClusterSnapshotRequest.getManualSnapshotRetentionPeriod()));
        }
        if (restoreFromClusterSnapshotRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getKmsKeyId()));
        }
        if (restoreFromClusterSnapshotRequest.getNodeType() != null) {
            request.addParameter("NodeType", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getNodeType()));
        }
        if (restoreFromClusterSnapshotRequest.getEnhancedVpcRouting() != null) {
            request.addParameter("EnhancedVpcRouting", StringUtils.fromBoolean((Boolean)restoreFromClusterSnapshotRequest.getEnhancedVpcRouting()));
        }
        if (restoreFromClusterSnapshotRequest.getAdditionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getAdditionalInfo()));
        }
        if (!restoreFromClusterSnapshotRequest.getIamRoles().isEmpty() || !((SdkInternalList)restoreFromClusterSnapshotRequest.getIamRoles()).isAutoConstruct()) {
            SdkInternalList iamRolesList = (SdkInternalList)restoreFromClusterSnapshotRequest.getIamRoles();
            int iamRolesListIndex = 1;
            for (String iamRolesListValue : iamRolesList) {
                if (iamRolesListValue != null) {
                    request.addParameter("IamRoles.IamRoleArn." + iamRolesListIndex, StringUtils.fromString((String)iamRolesListValue));
                }
                ++iamRolesListIndex;
            }
        }
        if (restoreFromClusterSnapshotRequest.getMaintenanceTrackName() != null) {
            request.addParameter("MaintenanceTrackName", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getMaintenanceTrackName()));
        }
        if (restoreFromClusterSnapshotRequest.getSnapshotScheduleIdentifier() != null) {
            request.addParameter("SnapshotScheduleIdentifier", StringUtils.fromString((String)restoreFromClusterSnapshotRequest.getSnapshotScheduleIdentifier()));
        }
        return request;
    }
}

