/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftinternal;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.redshiftinternal.AmazonRedshiftInternalAsync;
import com.amazonaws.services.redshiftinternal.AmazonRedshiftInternalAsyncClientBuilder;
import com.amazonaws.services.redshiftinternal.AmazonRedshiftInternalClient;
import com.amazonaws.services.redshiftinternal.model.GetClusterCredentialsWithIAMRequest;
import com.amazonaws.services.redshiftinternal.model.GetClusterCredentialsWithIAMResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonRedshiftInternalAsyncClient
extends AmazonRedshiftInternalClient
implements AmazonRedshiftInternalAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonRedshiftInternalAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonRedshiftInternalAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonRedshiftInternalAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonRedshiftInternalAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonRedshiftInternalAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonRedshiftInternalAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonRedshiftInternalAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonRedshiftInternalAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonRedshiftInternalAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonRedshiftInternalAsyncClientBuilder asyncBuilder() {
        return AmazonRedshiftInternalAsyncClientBuilder.standard();
    }

    AmazonRedshiftInternalAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonRedshiftInternalAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetClusterCredentialsWithIAMResult> getClusterCredentialsWithIAMAsync(GetClusterCredentialsWithIAMRequest request) {
        return this.getClusterCredentialsWithIAMAsync(request, null);
    }

    @Override
    public Future<GetClusterCredentialsWithIAMResult> getClusterCredentialsWithIAMAsync(GetClusterCredentialsWithIAMRequest request, final AsyncHandler<GetClusterCredentialsWithIAMRequest, GetClusterCredentialsWithIAMResult> asyncHandler) {
        final GetClusterCredentialsWithIAMRequest finalRequest = (GetClusterCredentialsWithIAMRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetClusterCredentialsWithIAMResult>(){

            @Override
            public GetClusterCredentialsWithIAMResult call() throws Exception {
                GetClusterCredentialsWithIAMResult result = null;
                try {
                    result = AmazonRedshiftInternalAsyncClient.this.executeGetClusterCredentialsWithIAM(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

