/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rdsdata.model.transform;

import com.amazonaws.services.rdsdata.model.ArrayValue;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class ArrayValueJsonUnmarshaller
implements Unmarshaller<ArrayValue, JsonUnmarshallerContext> {
    private static ArrayValueJsonUnmarshaller instance;

    public ArrayValue unmarshall(JsonUnmarshallerContext context) throws Exception {
        ArrayValue arrayValue = new ArrayValue();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("arrayValues", targetDepth)) {
                    context.nextToken();
                    arrayValue.setArrayValues(new ListUnmarshaller((Unmarshaller)ArrayValueJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("booleanValues", targetDepth)) {
                    context.nextToken();
                    arrayValue.setBooleanValues(new ListUnmarshaller(context.getUnmarshaller(Boolean.class)).unmarshall(context));
                }
                if (context.testExpression("doubleValues", targetDepth)) {
                    context.nextToken();
                    arrayValue.setDoubleValues(new ListUnmarshaller(context.getUnmarshaller(Double.class)).unmarshall(context));
                }
                if (context.testExpression("longValues", targetDepth)) {
                    context.nextToken();
                    arrayValue.setLongValues(new ListUnmarshaller(context.getUnmarshaller(Long.class)).unmarshall(context));
                }
                if (context.testExpression("stringValues", targetDepth)) {
                    context.nextToken();
                    arrayValue.setStringValues(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return arrayValue;
    }

    public static ArrayValueJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ArrayValueJsonUnmarshaller();
        }
        return instance;
    }
}

