/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CreateDBProxyEndpointRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateDBProxyEndpointRequestMarshaller
implements Marshaller<Request<CreateDBProxyEndpointRequest>, CreateDBProxyEndpointRequest> {
    public Request<CreateDBProxyEndpointRequest> marshall(CreateDBProxyEndpointRequest createDBProxyEndpointRequest) {
        if (createDBProxyEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDBProxyEndpointRequest, "AmazonRDS");
        request.addParameter("Action", "CreateDBProxyEndpoint");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDBProxyEndpointRequest.getDBProxyName() != null) {
            request.addParameter("DBProxyName", StringUtils.fromString((String)createDBProxyEndpointRequest.getDBProxyName()));
        }
        if (createDBProxyEndpointRequest.getDBProxyEndpointName() != null) {
            request.addParameter("DBProxyEndpointName", StringUtils.fromString((String)createDBProxyEndpointRequest.getDBProxyEndpointName()));
        }
        if (!createDBProxyEndpointRequest.getVpcSubnetIds().isEmpty() || !((SdkInternalList)createDBProxyEndpointRequest.getVpcSubnetIds()).isAutoConstruct()) {
            SdkInternalList vpcSubnetIdsList = (SdkInternalList)createDBProxyEndpointRequest.getVpcSubnetIds();
            int vpcSubnetIdsListIndex = 1;
            for (String vpcSubnetIdsListValue : vpcSubnetIdsList) {
                if (vpcSubnetIdsListValue != null) {
                    request.addParameter("VpcSubnetIds.member." + vpcSubnetIdsListIndex, StringUtils.fromString((String)vpcSubnetIdsListValue));
                }
                ++vpcSubnetIdsListIndex;
            }
        }
        if (!createDBProxyEndpointRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)createDBProxyEndpointRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)createDBProxyEndpointRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.member." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (createDBProxyEndpointRequest.getTargetRole() != null) {
            request.addParameter("TargetRole", StringUtils.fromString((String)createDBProxyEndpointRequest.getTargetRole()));
        }
        if (!createDBProxyEndpointRequest.getTags().isEmpty() || !((SdkInternalList)createDBProxyEndpointRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createDBProxyEndpointRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

