/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.RegisterDBProxyTargetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RegisterDBProxyTargetsRequestMarshaller
implements Marshaller<Request<RegisterDBProxyTargetsRequest>, RegisterDBProxyTargetsRequest> {
    public Request<RegisterDBProxyTargetsRequest> marshall(RegisterDBProxyTargetsRequest registerDBProxyTargetsRequest) {
        if (registerDBProxyTargetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerDBProxyTargetsRequest, "AmazonRDS");
        request.addParameter("Action", "RegisterDBProxyTargets");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (registerDBProxyTargetsRequest.getDBProxyName() != null) {
            request.addParameter("DBProxyName", StringUtils.fromString((String)registerDBProxyTargetsRequest.getDBProxyName()));
        }
        if (registerDBProxyTargetsRequest.getTargetGroupName() != null) {
            request.addParameter("TargetGroupName", StringUtils.fromString((String)registerDBProxyTargetsRequest.getTargetGroupName()));
        }
        if (!registerDBProxyTargetsRequest.getDBInstanceIdentifiers().isEmpty() || !((SdkInternalList)registerDBProxyTargetsRequest.getDBInstanceIdentifiers()).isAutoConstruct()) {
            SdkInternalList dBInstanceIdentifiersList = (SdkInternalList)registerDBProxyTargetsRequest.getDBInstanceIdentifiers();
            int dBInstanceIdentifiersListIndex = 1;
            for (String dBInstanceIdentifiersListValue : dBInstanceIdentifiersList) {
                if (dBInstanceIdentifiersListValue != null) {
                    request.addParameter("DBInstanceIdentifiers.member." + dBInstanceIdentifiersListIndex, StringUtils.fromString((String)dBInstanceIdentifiersListValue));
                }
                ++dBInstanceIdentifiersListIndex;
            }
        }
        if (!registerDBProxyTargetsRequest.getDBClusterIdentifiers().isEmpty() || !((SdkInternalList)registerDBProxyTargetsRequest.getDBClusterIdentifiers()).isAutoConstruct()) {
            SdkInternalList dBClusterIdentifiersList = (SdkInternalList)registerDBProxyTargetsRequest.getDBClusterIdentifiers();
            int dBClusterIdentifiersListIndex = 1;
            for (String dBClusterIdentifiersListValue : dBClusterIdentifiersList) {
                if (dBClusterIdentifiersListValue != null) {
                    request.addParameter("DBClusterIdentifiers.member." + dBClusterIdentifiersListIndex, StringUtils.fromString((String)dBClusterIdentifiersListValue));
                }
                ++dBClusterIdentifiersListIndex;
            }
        }
        return request;
    }
}

