/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CreateDBClusterEndpointRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateDBClusterEndpointRequestMarshaller
implements Marshaller<Request<CreateDBClusterEndpointRequest>, CreateDBClusterEndpointRequest> {
    public Request<CreateDBClusterEndpointRequest> marshall(CreateDBClusterEndpointRequest createDBClusterEndpointRequest) {
        if (createDBClusterEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDBClusterEndpointRequest, "AmazonRDS");
        request.addParameter("Action", "CreateDBClusterEndpoint");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDBClusterEndpointRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)createDBClusterEndpointRequest.getDBClusterIdentifier()));
        }
        if (createDBClusterEndpointRequest.getDBClusterEndpointIdentifier() != null) {
            request.addParameter("DBClusterEndpointIdentifier", StringUtils.fromString((String)createDBClusterEndpointRequest.getDBClusterEndpointIdentifier()));
        }
        if (createDBClusterEndpointRequest.getEndpointType() != null) {
            request.addParameter("EndpointType", StringUtils.fromString((String)createDBClusterEndpointRequest.getEndpointType()));
        }
        if (!createDBClusterEndpointRequest.getStaticMembers().isEmpty() || !((SdkInternalList)createDBClusterEndpointRequest.getStaticMembers()).isAutoConstruct()) {
            SdkInternalList staticMembersList = (SdkInternalList)createDBClusterEndpointRequest.getStaticMembers();
            int staticMembersListIndex = 1;
            for (String staticMembersListValue : staticMembersList) {
                if (staticMembersListValue != null) {
                    request.addParameter("StaticMembers.member." + staticMembersListIndex, StringUtils.fromString((String)staticMembersListValue));
                }
                ++staticMembersListIndex;
            }
        }
        if (!createDBClusterEndpointRequest.getExcludedMembers().isEmpty() || !((SdkInternalList)createDBClusterEndpointRequest.getExcludedMembers()).isAutoConstruct()) {
            SdkInternalList excludedMembersList = (SdkInternalList)createDBClusterEndpointRequest.getExcludedMembers();
            int excludedMembersListIndex = 1;
            for (String excludedMembersListValue : excludedMembersList) {
                if (excludedMembersListValue != null) {
                    request.addParameter("ExcludedMembers.member." + excludedMembersListIndex, StringUtils.fromString((String)excludedMembersListValue));
                }
                ++excludedMembersListIndex;
            }
        }
        if (!createDBClusterEndpointRequest.getTags().isEmpty() || !((SdkInternalList)createDBClusterEndpointRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createDBClusterEndpointRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

