/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.Parameter;
import com.amazonaws.services.rds.model.ResetDBClusterParameterGroupRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ResetDBClusterParameterGroupRequestMarshaller
implements Marshaller<Request<ResetDBClusterParameterGroupRequest>, ResetDBClusterParameterGroupRequest> {
    public Request<ResetDBClusterParameterGroupRequest> marshall(ResetDBClusterParameterGroupRequest resetDBClusterParameterGroupRequest) {
        if (resetDBClusterParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)resetDBClusterParameterGroupRequest, "AmazonRDS");
        request.addParameter("Action", "ResetDBClusterParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetDBClusterParameterGroupRequest.getDBClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString((String)resetDBClusterParameterGroupRequest.getDBClusterParameterGroupName()));
        }
        if (resetDBClusterParameterGroupRequest.getResetAllParameters() != null) {
            request.addParameter("ResetAllParameters", StringUtils.fromBoolean((Boolean)resetDBClusterParameterGroupRequest.getResetAllParameters()));
        }
        if (!resetDBClusterParameterGroupRequest.getParameters().isEmpty() || !((SdkInternalList)resetDBClusterParameterGroupRequest.getParameters()).isAutoConstruct()) {
            SdkInternalList parametersList = (SdkInternalList)resetDBClusterParameterGroupRequest.getParameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue.getParameterName() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterName", StringUtils.fromString((String)parametersListValue.getParameterName()));
                }
                if (parametersListValue.getParameterValue() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parametersListValue.getParameterValue()));
                }
                if (parametersListValue.getDescription() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".Description", StringUtils.fromString((String)parametersListValue.getDescription()));
                }
                if (parametersListValue.getSource() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".Source", StringUtils.fromString((String)parametersListValue.getSource()));
                }
                if (parametersListValue.getApplyType() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".ApplyType", StringUtils.fromString((String)parametersListValue.getApplyType()));
                }
                if (parametersListValue.getDataType() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".DataType", StringUtils.fromString((String)parametersListValue.getDataType()));
                }
                if (parametersListValue.getAllowedValues() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".AllowedValues", StringUtils.fromString((String)parametersListValue.getAllowedValues()));
                }
                if (parametersListValue.getIsModifiable() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".IsModifiable", StringUtils.fromBoolean((Boolean)parametersListValue.getIsModifiable()));
                }
                if (parametersListValue.getMinimumEngineVersion() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".MinimumEngineVersion", StringUtils.fromString((String)parametersListValue.getMinimumEngineVersion()));
                }
                if (parametersListValue.getApplyMethod() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".ApplyMethod", StringUtils.fromString((String)parametersListValue.getApplyMethod()));
                }
                if (!parametersListValue.getSupportedEngineModes().isEmpty() || !((SdkInternalList)parametersListValue.getSupportedEngineModes()).isAutoConstruct()) {
                    SdkInternalList supportedEngineModesList = (SdkInternalList)parametersListValue.getSupportedEngineModes();
                    int supportedEngineModesListIndex = 1;
                    for (String supportedEngineModesListValue : supportedEngineModesList) {
                        if (supportedEngineModesListValue != null) {
                            request.addParameter("Parameters.Parameter." + parametersListIndex + ".SupportedEngineModes.member." + supportedEngineModesListIndex, StringUtils.fromString((String)supportedEngineModesListValue));
                        }
                        ++supportedEngineModesListIndex;
                    }
                }
                ++parametersListIndex;
            }
        }
        return request;
    }
}

