/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.rds.model.DescribeDBClusterParametersRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeDBClusterParametersRequestMarshaller
implements Marshaller<Request<DescribeDBClusterParametersRequest>, DescribeDBClusterParametersRequest> {
    public Request<DescribeDBClusterParametersRequest> marshall(DescribeDBClusterParametersRequest describeDBClusterParametersRequest) {
        if (describeDBClusterParametersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBClusterParametersRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeDBClusterParameters");
        request.addParameter("Version", "2014-10-31");
        if (describeDBClusterParametersRequest.getDBClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString((String)describeDBClusterParametersRequest.getDBClusterParameterGroupName()));
        }
        if (describeDBClusterParametersRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString((String)describeDBClusterParametersRequest.getSource()));
        }
        List<Filter> filtersList = describeDBClusterParametersRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        if (describeDBClusterParametersRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBClusterParametersRequest.getMaxRecords()));
        }
        if (describeDBClusterParametersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBClusterParametersRequest.getMarker()));
        }
        return request;
    }
}

