/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Certificate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeCertificatesResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Certificate> certificates;
    private String marker;

    public List<Certificate> getCertificates() {
        if (this.certificates == null) {
            this.certificates = new ListWithAutoConstructFlag();
            this.certificates.setAutoConstruct(true);
        }
        return this.certificates;
    }

    public void setCertificates(Collection<Certificate> certificates) {
        if (certificates == null) {
            this.certificates = null;
            return;
        }
        ListWithAutoConstructFlag certificatesCopy = new ListWithAutoConstructFlag(certificates.size());
        certificatesCopy.addAll(certificates);
        this.certificates = certificatesCopy;
    }

    public DescribeCertificatesResult withCertificates(Certificate ... certificates) {
        if (this.getCertificates() == null) {
            this.setCertificates(new ArrayList<Certificate>(certificates.length));
        }
        for (Certificate value : certificates) {
            this.getCertificates().add(value);
        }
        return this;
    }

    public DescribeCertificatesResult withCertificates(Collection<Certificate> certificates) {
        if (certificates == null) {
            this.certificates = null;
        } else {
            ListWithAutoConstructFlag certificatesCopy = new ListWithAutoConstructFlag(certificates.size());
            certificatesCopy.addAll(certificates);
            this.certificates = certificatesCopy;
        }
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public DescribeCertificatesResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCertificates() != null) {
            sb.append("Certificates: " + this.getCertificates() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCertificates() == null ? 0 : this.getCertificates().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCertificatesResult)) {
            return false;
        }
        DescribeCertificatesResult other = (DescribeCertificatesResult)obj;
        if (other.getCertificates() == null ^ this.getCertificates() == null) {
            return false;
        }
        if (other.getCertificates() != null && !other.getCertificates().equals(this.getCertificates())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public DescribeCertificatesResult clone() {
        try {
            return (DescribeCertificatesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

