/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.rds.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDBClusterSnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String dBClusterSnapshotIdentifier;
    private String dBClusterIdentifier;
    private ListWithAutoConstructFlag<Tag> tags;

    public String getDBClusterSnapshotIdentifier() {
        return this.dBClusterSnapshotIdentifier;
    }

    public void setDBClusterSnapshotIdentifier(String dBClusterSnapshotIdentifier) {
        this.dBClusterSnapshotIdentifier = dBClusterSnapshotIdentifier;
    }

    public CreateDBClusterSnapshotRequest withDBClusterSnapshotIdentifier(String dBClusterSnapshotIdentifier) {
        this.dBClusterSnapshotIdentifier = dBClusterSnapshotIdentifier;
        return this;
    }

    public String getDBClusterIdentifier() {
        return this.dBClusterIdentifier;
    }

    public void setDBClusterIdentifier(String dBClusterIdentifier) {
        this.dBClusterIdentifier = dBClusterIdentifier;
    }

    public CreateDBClusterSnapshotRequest withDBClusterIdentifier(String dBClusterIdentifier) {
        this.dBClusterIdentifier = dBClusterIdentifier;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public CreateDBClusterSnapshotRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public CreateDBClusterSnapshotRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBClusterSnapshotIdentifier() != null) {
            sb.append("DBClusterSnapshotIdentifier: " + this.getDBClusterSnapshotIdentifier() + ",");
        }
        if (this.getDBClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: " + this.getDBClusterIdentifier() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBClusterSnapshotIdentifier() == null ? 0 : this.getDBClusterSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterIdentifier() == null ? 0 : this.getDBClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDBClusterSnapshotRequest)) {
            return false;
        }
        CreateDBClusterSnapshotRequest other = (CreateDBClusterSnapshotRequest)obj;
        if (other.getDBClusterSnapshotIdentifier() == null ^ this.getDBClusterSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getDBClusterSnapshotIdentifier() != null && !other.getDBClusterSnapshotIdentifier().equals(this.getDBClusterSnapshotIdentifier())) {
            return false;
        }
        if (other.getDBClusterIdentifier() == null ^ this.getDBClusterIdentifier() == null) {
            return false;
        }
        if (other.getDBClusterIdentifier() != null && !other.getDBClusterIdentifier().equals(this.getDBClusterIdentifier())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public CreateDBClusterSnapshotRequest clone() {
        return (CreateDBClusterSnapshotRequest)super.clone();
    }
}

