/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.ThemeVersion;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ThemeVersionMarshaller {
    private static final MarshallingInfo<Long> VERSIONNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VersionNumber").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<String> BASETHEMEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BaseThemeId").build();
    private static final MarshallingInfo<Date> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> CONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Configuration").build();
    private static final MarshallingInfo<List> ERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Errors").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final ThemeVersionMarshaller instance = new ThemeVersionMarshaller();

    public static ThemeVersionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ThemeVersion themeVersion, ProtocolMarshaller protocolMarshaller) {
        if (themeVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)themeVersion.getVersionNumber(), VERSIONNUMBER_BINDING);
            protocolMarshaller.marshall((Object)themeVersion.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)themeVersion.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)themeVersion.getBaseThemeId(), BASETHEMEID_BINDING);
            protocolMarshaller.marshall((Object)themeVersion.getCreatedTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)themeVersion.getConfiguration(), CONFIGURATION_BINDING);
            protocolMarshaller.marshall(themeVersion.getErrors(), ERRORS_BINDING);
            protocolMarshaller.marshall((Object)themeVersion.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

