/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.RelationalTable;
import java.util.List;

@SdkInternalApi
public class RelationalTableMarshaller {
    private static final MarshallingInfo<String> DATASOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataSourceArn").build();
    private static final MarshallingInfo<String> CATALOG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Catalog").build();
    private static final MarshallingInfo<String> SCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Schema").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<List> INPUTCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputColumns").build();
    private static final RelationalTableMarshaller instance = new RelationalTableMarshaller();

    public static RelationalTableMarshaller getInstance() {
        return instance;
    }

    public void marshall(RelationalTable relationalTable, ProtocolMarshaller protocolMarshaller) {
        if (relationalTable == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)relationalTable.getDataSourceArn(), DATASOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)relationalTable.getCatalog(), CATALOG_BINDING);
            protocolMarshaller.marshall((Object)relationalTable.getSchema(), SCHEMA_BINDING);
            protocolMarshaller.marshall((Object)relationalTable.getName(), NAME_BINDING);
            protocolMarshaller.marshall(relationalTable.getInputColumns(), INPUTCOLUMNS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

