/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.DataColorPalette;
import java.util.List;

@SdkInternalApi
public class DataColorPaletteMarshaller {
    private static final MarshallingInfo<List> COLORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Colors").build();
    private static final MarshallingInfo<List> MINMAXGRADIENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinMaxGradient").build();
    private static final MarshallingInfo<String> EMPTYFILLCOLOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmptyFillColor").build();
    private static final DataColorPaletteMarshaller instance = new DataColorPaletteMarshaller();

    public static DataColorPaletteMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataColorPalette dataColorPalette, ProtocolMarshaller protocolMarshaller) {
        if (dataColorPalette == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dataColorPalette.getColors(), COLORS_BINDING);
            protocolMarshaller.marshall(dataColorPalette.getMinMaxGradient(), MINMAXGRADIENT_BINDING);
            protocolMarshaller.marshall((Object)dataColorPalette.getEmptyFillColor(), EMPTYFILLCOLOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

