/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.InputColumn;
import com.amazonaws.services.quicksight.model.transform.RelationalTableMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RelationalTable
implements Serializable,
Cloneable,
StructuredPojo {
    private String dataSourceArn;
    private String schema;
    private String name;
    private List<InputColumn> inputColumns;

    public void setDataSourceArn(String dataSourceArn) {
        this.dataSourceArn = dataSourceArn;
    }

    public String getDataSourceArn() {
        return this.dataSourceArn;
    }

    public RelationalTable withDataSourceArn(String dataSourceArn) {
        this.setDataSourceArn(dataSourceArn);
        return this;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getSchema() {
        return this.schema;
    }

    public RelationalTable withSchema(String schema) {
        this.setSchema(schema);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RelationalTable withName(String name) {
        this.setName(name);
        return this;
    }

    public List<InputColumn> getInputColumns() {
        return this.inputColumns;
    }

    public void setInputColumns(Collection<InputColumn> inputColumns) {
        if (inputColumns == null) {
            this.inputColumns = null;
            return;
        }
        this.inputColumns = new ArrayList<InputColumn>(inputColumns);
    }

    public RelationalTable withInputColumns(InputColumn ... inputColumns) {
        if (this.inputColumns == null) {
            this.setInputColumns(new ArrayList<InputColumn>(inputColumns.length));
        }
        for (InputColumn ele : inputColumns) {
            this.inputColumns.add(ele);
        }
        return this;
    }

    public RelationalTable withInputColumns(Collection<InputColumn> inputColumns) {
        this.setInputColumns(inputColumns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSourceArn() != null) {
            sb.append("DataSourceArn: ").append(this.getDataSourceArn()).append(",");
        }
        if (this.getSchema() != null) {
            sb.append("Schema: ").append(this.getSchema()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getInputColumns() != null) {
            sb.append("InputColumns: ").append(this.getInputColumns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalTable)) {
            return false;
        }
        RelationalTable other = (RelationalTable)obj;
        if (other.getDataSourceArn() == null ^ this.getDataSourceArn() == null) {
            return false;
        }
        if (other.getDataSourceArn() != null && !other.getDataSourceArn().equals(this.getDataSourceArn())) {
            return false;
        }
        if (other.getSchema() == null ^ this.getSchema() == null) {
            return false;
        }
        if (other.getSchema() != null && !other.getSchema().equals(this.getSchema())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getInputColumns() == null ^ this.getInputColumns() == null) {
            return false;
        }
        return other.getInputColumns() == null || other.getInputColumns().equals(this.getInputColumns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSourceArn() == null ? 0 : this.getDataSourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getSchema() == null ? 0 : this.getSchema().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getInputColumns() == null ? 0 : this.getInputColumns().hashCode());
        return hashCode;
    }

    public RelationalTable clone() {
        try {
            return (RelationalTable)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RelationalTableMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

