/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.qldbsession.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.qldbsession.model.ValueHolder;
import com.amazonaws.services.qldbsession.model.transform.ExecuteStatementRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExecuteStatementRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private String transactionId;
    private String statement;
    private List<ValueHolder> parameters;

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public ExecuteStatementRequest withTransactionId(String transactionId) {
        this.setTransactionId(transactionId);
        return this;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public String getStatement() {
        return this.statement;
    }

    public ExecuteStatementRequest withStatement(String statement) {
        this.setStatement(statement);
        return this;
    }

    public List<ValueHolder> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<ValueHolder> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new ArrayList<ValueHolder>(parameters);
    }

    public ExecuteStatementRequest withParameters(ValueHolder ... parameters) {
        if (this.parameters == null) {
            this.setParameters(new ArrayList<ValueHolder>(parameters.length));
        }
        for (ValueHolder ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    public ExecuteStatementRequest withParameters(Collection<ValueHolder> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTransactionId() != null) {
            sb.append("TransactionId: ").append(this.getTransactionId()).append(",");
        }
        if (this.getStatement() != null) {
            sb.append("Statement: ").append(this.getStatement()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementRequest)) {
            return false;
        }
        ExecuteStatementRequest other = (ExecuteStatementRequest)obj;
        if (other.getTransactionId() == null ^ this.getTransactionId() == null) {
            return false;
        }
        if (other.getTransactionId() != null && !other.getTransactionId().equals(this.getTransactionId())) {
            return false;
        }
        if (other.getStatement() == null ^ this.getStatement() == null) {
            return false;
        }
        if (other.getStatement() != null && !other.getStatement().equals(this.getStatement())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTransactionId() == null ? 0 : this.getTransactionId().hashCode());
        hashCode = 31 * hashCode + (this.getStatement() == null ? 0 : this.getStatement().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public ExecuteStatementRequest clone() {
        try {
            return (ExecuteStatementRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExecuteStatementRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

