/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.pinpoint.model.InAppMessageContent;
import com.amazonaws.services.pinpoint.model.Layout;
import com.amazonaws.services.pinpoint.model.transform.InAppTemplateRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InAppTemplateRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private List<InAppMessageContent> content;
    private Map<String, String> customConfig;
    private String layout;
    private Map<String, String> tags;
    private String templateDescription;

    public List<InAppMessageContent> getContent() {
        return this.content;
    }

    public void setContent(Collection<InAppMessageContent> content) {
        if (content == null) {
            this.content = null;
            return;
        }
        this.content = new ArrayList<InAppMessageContent>(content);
    }

    public InAppTemplateRequest withContent(InAppMessageContent ... content) {
        if (this.content == null) {
            this.setContent(new ArrayList<InAppMessageContent>(content.length));
        }
        for (InAppMessageContent ele : content) {
            this.content.add(ele);
        }
        return this;
    }

    public InAppTemplateRequest withContent(Collection<InAppMessageContent> content) {
        this.setContent(content);
        return this;
    }

    public Map<String, String> getCustomConfig() {
        return this.customConfig;
    }

    public void setCustomConfig(Map<String, String> customConfig) {
        this.customConfig = customConfig;
    }

    public InAppTemplateRequest withCustomConfig(Map<String, String> customConfig) {
        this.setCustomConfig(customConfig);
        return this;
    }

    public InAppTemplateRequest addCustomConfigEntry(String key, String value) {
        if (null == this.customConfig) {
            this.customConfig = new HashMap<String, String>();
        }
        if (this.customConfig.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.customConfig.put(key, value);
        return this;
    }

    public InAppTemplateRequest clearCustomConfigEntries() {
        this.customConfig = null;
        return this;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getLayout() {
        return this.layout;
    }

    public InAppTemplateRequest withLayout(String layout) {
        this.setLayout(layout);
        return this;
    }

    public InAppTemplateRequest withLayout(Layout layout) {
        this.layout = layout.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public InAppTemplateRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public InAppTemplateRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public InAppTemplateRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setTemplateDescription(String templateDescription) {
        this.templateDescription = templateDescription;
    }

    public String getTemplateDescription() {
        return this.templateDescription;
    }

    public InAppTemplateRequest withTemplateDescription(String templateDescription) {
        this.setTemplateDescription(templateDescription);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContent() != null) {
            sb.append("Content: ").append(this.getContent()).append(",");
        }
        if (this.getCustomConfig() != null) {
            sb.append("CustomConfig: ").append(this.getCustomConfig()).append(",");
        }
        if (this.getLayout() != null) {
            sb.append("Layout: ").append(this.getLayout()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTemplateDescription() != null) {
            sb.append("TemplateDescription: ").append(this.getTemplateDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppTemplateRequest)) {
            return false;
        }
        InAppTemplateRequest other = (InAppTemplateRequest)obj;
        if (other.getContent() == null ^ this.getContent() == null) {
            return false;
        }
        if (other.getContent() != null && !other.getContent().equals(this.getContent())) {
            return false;
        }
        if (other.getCustomConfig() == null ^ this.getCustomConfig() == null) {
            return false;
        }
        if (other.getCustomConfig() != null && !other.getCustomConfig().equals(this.getCustomConfig())) {
            return false;
        }
        if (other.getLayout() == null ^ this.getLayout() == null) {
            return false;
        }
        if (other.getLayout() != null && !other.getLayout().equals(this.getLayout())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTemplateDescription() == null ^ this.getTemplateDescription() == null) {
            return false;
        }
        return other.getTemplateDescription() == null || other.getTemplateDescription().equals(this.getTemplateDescription());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContent() == null ? 0 : this.getContent().hashCode());
        hashCode = 31 * hashCode + (this.getCustomConfig() == null ? 0 : this.getCustomConfig().hashCode());
        hashCode = 31 * hashCode + (this.getLayout() == null ? 0 : this.getLayout().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateDescription() == null ? 0 : this.getTemplateDescription().hashCode());
        return hashCode;
    }

    public InAppTemplateRequest clone() {
        try {
            return (InAppTemplateRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InAppTemplateRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

