/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.personalize.model.SolutionSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSolutionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<SolutionSummary> solutions;
    private String nextToken;

    public List<SolutionSummary> getSolutions() {
        return this.solutions;
    }

    public void setSolutions(Collection<SolutionSummary> solutions) {
        if (solutions == null) {
            this.solutions = null;
            return;
        }
        this.solutions = new ArrayList<SolutionSummary>(solutions);
    }

    public ListSolutionsResult withSolutions(SolutionSummary ... solutions) {
        if (this.solutions == null) {
            this.setSolutions(new ArrayList<SolutionSummary>(solutions.length));
        }
        for (SolutionSummary ele : solutions) {
            this.solutions.add(ele);
        }
        return this;
    }

    public ListSolutionsResult withSolutions(Collection<SolutionSummary> solutions) {
        this.setSolutions(solutions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSolutionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSolutions() != null) {
            sb.append("Solutions: ").append(this.getSolutions()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolutionsResult)) {
            return false;
        }
        ListSolutionsResult other = (ListSolutionsResult)obj;
        if (other.getSolutions() == null ^ this.getSolutions() == null) {
            return false;
        }
        if (other.getSolutions() != null && !other.getSolutions().equals(this.getSolutions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSolutions() == null ? 0 : this.getSolutions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListSolutionsResult clone() {
        try {
            return (ListSolutionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

