/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.panorama.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.panorama.model.transform.PackageListItemMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PackageListItem
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private Date createdTime;
    private String packageId;
    private String packageName;
    private Map<String, String> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public PackageListItem withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public PackageListItem withCreatedTime(Date createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public PackageListItem withPackageId(String packageId) {
        this.setPackageId(packageId);
        return this;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public PackageListItem withPackageName(String packageName) {
        this.setPackageName(packageName);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public PackageListItem withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public PackageListItem addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public PackageListItem clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getPackageId() != null) {
            sb.append("PackageId: ").append(this.getPackageId()).append(",");
        }
        if (this.getPackageName() != null) {
            sb.append("PackageName: ").append(this.getPackageName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageListItem)) {
            return false;
        }
        PackageListItem other = (PackageListItem)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getPackageId() == null ^ this.getPackageId() == null) {
            return false;
        }
        if (other.getPackageId() != null && !other.getPackageId().equals(this.getPackageId())) {
            return false;
        }
        if (other.getPackageName() == null ^ this.getPackageName() == null) {
            return false;
        }
        if (other.getPackageName() != null && !other.getPackageName().equals(this.getPackageName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getPackageId() == null ? 0 : this.getPackageId().hashCode());
        hashCode = 31 * hashCode + (this.getPackageName() == null ? 0 : this.getPackageName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public PackageListItem clone() {
        try {
            return (PackageListItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PackageListItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

