/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.outposts.model.LineItem;

@SdkInternalApi
public class LineItemMarshaller {
    private static final MarshallingInfo<String> CATALOGITEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogItemId").build();
    private static final MarshallingInfo<String> LINEITEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LineItemId").build();
    private static final MarshallingInfo<Integer> QUANTITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Quantity").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final LineItemMarshaller instance = new LineItemMarshaller();

    public static LineItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(LineItem lineItem, ProtocolMarshaller protocolMarshaller) {
        if (lineItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)lineItem.getCatalogItemId(), CATALOGITEMID_BINDING);
            protocolMarshaller.marshall((Object)lineItem.getLineItemId(), LINEITEMID_BINDING);
            protocolMarshaller.marshall((Object)lineItem.getQuantity(), QUANTITY_BINDING);
            protocolMarshaller.marshall((Object)lineItem.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

