/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.opensearch.model.StorageType;
import java.util.List;

@SdkInternalApi
public class StorageTypeMarshaller {
    private static final MarshallingInfo<String> STORAGETYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageTypeName").build();
    private static final MarshallingInfo<String> STORAGESUBTYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageSubTypeName").build();
    private static final MarshallingInfo<List> STORAGETYPELIMITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageTypeLimits").build();
    private static final StorageTypeMarshaller instance = new StorageTypeMarshaller();

    public static StorageTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(StorageType storageType, ProtocolMarshaller protocolMarshaller) {
        if (storageType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)storageType.getStorageTypeName(), STORAGETYPENAME_BINDING);
            protocolMarshaller.marshall((Object)storageType.getStorageSubTypeName(), STORAGESUBTYPENAME_BINDING);
            protocolMarshaller.marshall(storageType.getStorageTypeLimits(), STORAGETYPELIMITS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

