/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mq.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mq.model.transform.UserMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class User
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean consoleAccess;
    private List<String> groups;
    private String password;
    private String username;

    public void setConsoleAccess(Boolean consoleAccess) {
        this.consoleAccess = consoleAccess;
    }

    public Boolean getConsoleAccess() {
        return this.consoleAccess;
    }

    public User withConsoleAccess(Boolean consoleAccess) {
        this.setConsoleAccess(consoleAccess);
        return this;
    }

    public Boolean isConsoleAccess() {
        return this.consoleAccess;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new ArrayList<String>(groups);
    }

    public User withGroups(String ... groups) {
        if (this.groups == null) {
            this.setGroups(new ArrayList<String>(groups.length));
        }
        for (String ele : groups) {
            this.groups.add(ele);
        }
        return this;
    }

    public User withGroups(Collection<String> groups) {
        this.setGroups(groups);
        return this;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public User withPassword(String password) {
        this.setPassword(password);
        return this;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public User withUsername(String username) {
        this.setUsername(username);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConsoleAccess() != null) {
            sb.append("ConsoleAccess: ").append(this.getConsoleAccess()).append(",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: ").append(this.getGroups()).append(",");
        }
        if (this.getPassword() != null) {
            sb.append("Password: ").append(this.getPassword()).append(",");
        }
        if (this.getUsername() != null) {
            sb.append("Username: ").append(this.getUsername());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        if (other.getConsoleAccess() == null ^ this.getConsoleAccess() == null) {
            return false;
        }
        if (other.getConsoleAccess() != null && !other.getConsoleAccess().equals(this.getConsoleAccess())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getPassword() == null ^ this.getPassword() == null) {
            return false;
        }
        if (other.getPassword() != null && !other.getPassword().equals(this.getPassword())) {
            return false;
        }
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        return other.getUsername() == null || other.getUsername().equals(this.getUsername());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConsoleAccess() == null ? 0 : this.getConsoleAccess().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        return hashCode;
    }

    public User clone() {
        try {
            return (User)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

