/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.migrationhuborchestrator.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.migrationhuborchestrator.model.transform.StepInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StepInput
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer integerValue;
    private String stringValue;
    private List<String> listOfStringsValue;
    private Map<String, String> mapOfStringValue;

    public void setIntegerValue(Integer integerValue) {
        this.integerValue = integerValue;
    }

    public Integer getIntegerValue() {
        return this.integerValue;
    }

    public StepInput withIntegerValue(Integer integerValue) {
        this.setIntegerValue(integerValue);
        return this;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public StepInput withStringValue(String stringValue) {
        this.setStringValue(stringValue);
        return this;
    }

    public List<String> getListOfStringsValue() {
        return this.listOfStringsValue;
    }

    public void setListOfStringsValue(Collection<String> listOfStringsValue) {
        if (listOfStringsValue == null) {
            this.listOfStringsValue = null;
            return;
        }
        this.listOfStringsValue = new ArrayList<String>(listOfStringsValue);
    }

    public StepInput withListOfStringsValue(String ... listOfStringsValue) {
        if (this.listOfStringsValue == null) {
            this.setListOfStringsValue(new ArrayList<String>(listOfStringsValue.length));
        }
        for (String ele : listOfStringsValue) {
            this.listOfStringsValue.add(ele);
        }
        return this;
    }

    public StepInput withListOfStringsValue(Collection<String> listOfStringsValue) {
        this.setListOfStringsValue(listOfStringsValue);
        return this;
    }

    public Map<String, String> getMapOfStringValue() {
        return this.mapOfStringValue;
    }

    public void setMapOfStringValue(Map<String, String> mapOfStringValue) {
        this.mapOfStringValue = mapOfStringValue;
    }

    public StepInput withMapOfStringValue(Map<String, String> mapOfStringValue) {
        this.setMapOfStringValue(mapOfStringValue);
        return this;
    }

    public StepInput addMapOfStringValueEntry(String key, String value) {
        if (null == this.mapOfStringValue) {
            this.mapOfStringValue = new HashMap<String, String>();
        }
        if (this.mapOfStringValue.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.mapOfStringValue.put(key, value);
        return this;
    }

    public StepInput clearMapOfStringValueEntries() {
        this.mapOfStringValue = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIntegerValue() != null) {
            sb.append("IntegerValue: ").append(this.getIntegerValue()).append(",");
        }
        if (this.getStringValue() != null) {
            sb.append("StringValue: ").append(this.getStringValue()).append(",");
        }
        if (this.getListOfStringsValue() != null) {
            sb.append("ListOfStringsValue: ").append(this.getListOfStringsValue()).append(",");
        }
        if (this.getMapOfStringValue() != null) {
            sb.append("MapOfStringValue: ").append(this.getMapOfStringValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepInput)) {
            return false;
        }
        StepInput other = (StepInput)obj;
        if (other.getIntegerValue() == null ^ this.getIntegerValue() == null) {
            return false;
        }
        if (other.getIntegerValue() != null && !other.getIntegerValue().equals(this.getIntegerValue())) {
            return false;
        }
        if (other.getStringValue() == null ^ this.getStringValue() == null) {
            return false;
        }
        if (other.getStringValue() != null && !other.getStringValue().equals(this.getStringValue())) {
            return false;
        }
        if (other.getListOfStringsValue() == null ^ this.getListOfStringsValue() == null) {
            return false;
        }
        if (other.getListOfStringsValue() != null && !other.getListOfStringsValue().equals(this.getListOfStringsValue())) {
            return false;
        }
        if (other.getMapOfStringValue() == null ^ this.getMapOfStringValue() == null) {
            return false;
        }
        return other.getMapOfStringValue() == null || other.getMapOfStringValue().equals(this.getMapOfStringValue());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIntegerValue() == null ? 0 : this.getIntegerValue().hashCode());
        hashCode = 31 * hashCode + (this.getStringValue() == null ? 0 : this.getStringValue().hashCode());
        hashCode = 31 * hashCode + (this.getListOfStringsValue() == null ? 0 : this.getListOfStringsValue().hashCode());
        hashCode = 31 * hashCode + (this.getMapOfStringValue() == null ? 0 : this.getMapOfStringValue().hashCode());
        return hashCode;
    }

    public StepInput clone() {
        try {
            return (StepInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

