/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.Policy;

@SdkInternalApi
public class PolicyMarshaller {
    private static final MarshallingInfo<String> HTTPINPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("httpInputs").build();
    private static final MarshallingInfo<String> HTTPSINPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("httpsInputs").build();
    private static final MarshallingInfo<String> S3INPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Inputs").build();
    private static final PolicyMarshaller instance = new PolicyMarshaller();

    public static PolicyMarshaller getInstance() {
        return instance;
    }

    public void marshall(Policy policy, ProtocolMarshaller protocolMarshaller) {
        if (policy == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)policy.getHttpInputs(), HTTPINPUTS_BINDING);
            protocolMarshaller.marshall((Object)policy.getHttpsInputs(), HTTPSINPUTS_BINDING);
            protocolMarshaller.marshall((Object)policy.getS3Inputs(), S3INPUTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

