/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model.transform;

import com.amazonaws.services.mediaconnect.model.MediaStream;
import com.amazonaws.services.mediaconnect.model.transform.MediaStreamAttributesJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class MediaStreamJsonUnmarshaller
implements Unmarshaller<MediaStream, JsonUnmarshallerContext> {
    private static MediaStreamJsonUnmarshaller instance;

    public MediaStream unmarshall(JsonUnmarshallerContext context) throws Exception {
        MediaStream mediaStream = new MediaStream();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("attributes", targetDepth)) {
                    context.nextToken();
                    mediaStream.setAttributes(MediaStreamAttributesJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("clockRate", targetDepth)) {
                    context.nextToken();
                    mediaStream.setClockRate((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    mediaStream.setDescription((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("fmt", targetDepth)) {
                    context.nextToken();
                    mediaStream.setFmt((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("mediaStreamId", targetDepth)) {
                    context.nextToken();
                    mediaStream.setMediaStreamId((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("mediaStreamName", targetDepth)) {
                    context.nextToken();
                    mediaStream.setMediaStreamName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("mediaStreamType", targetDepth)) {
                    context.nextToken();
                    mediaStream.setMediaStreamType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("videoFormat", targetDepth)) {
                    context.nextToken();
                    mediaStream.setVideoFormat((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return mediaStream;
    }

    public static MediaStreamJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MediaStreamJsonUnmarshaller();
        }
        return instance;
    }
}

