/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplaceentitlement;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.marketplaceentitlement.AWSMarketplaceEntitlementAsync;
import com.amazonaws.services.marketplaceentitlement.AWSMarketplaceEntitlementAsyncClientBuilder;
import com.amazonaws.services.marketplaceentitlement.AWSMarketplaceEntitlementClient;
import com.amazonaws.services.marketplaceentitlement.model.GetEntitlementsRequest;
import com.amazonaws.services.marketplaceentitlement.model.GetEntitlementsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSMarketplaceEntitlementAsyncClient
extends AWSMarketplaceEntitlementClient
implements AWSMarketplaceEntitlementAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSMarketplaceEntitlementAsyncClientBuilder asyncBuilder() {
        return AWSMarketplaceEntitlementAsyncClientBuilder.standard();
    }

    AWSMarketplaceEntitlementAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSMarketplaceEntitlementAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetEntitlementsResult> getEntitlementsAsync(GetEntitlementsRequest request) {
        return this.getEntitlementsAsync(request, null);
    }

    @Override
    public Future<GetEntitlementsResult> getEntitlementsAsync(GetEntitlementsRequest request, final AsyncHandler<GetEntitlementsRequest, GetEntitlementsResult> asyncHandler) {
        final GetEntitlementsRequest finalRequest = (GetEntitlementsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEntitlementsResult>(){

            @Override
            public GetEntitlementsResult call() throws Exception {
                GetEntitlementsResult result = null;
                try {
                    result = AWSMarketplaceEntitlementAsyncClient.this.executeGetEntitlements(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

