/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie.model.ClassificationType;
import com.amazonaws.services.macie.model.transform.S3ResourceClassificationMarshaller;
import java.io.Serializable;

public class S3ResourceClassification
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketName;
    private String prefix;
    private ClassificationType classificationType;

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public S3ResourceClassification withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public S3ResourceClassification withPrefix(String prefix) {
        this.setPrefix(prefix);
        return this;
    }

    public void setClassificationType(ClassificationType classificationType) {
        this.classificationType = classificationType;
    }

    public ClassificationType getClassificationType() {
        return this.classificationType;
    }

    public S3ResourceClassification withClassificationType(ClassificationType classificationType) {
        this.setClassificationType(classificationType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getPrefix() != null) {
            sb.append("Prefix: ").append(this.getPrefix()).append(",");
        }
        if (this.getClassificationType() != null) {
            sb.append("ClassificationType: ").append(this.getClassificationType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ResourceClassification)) {
            return false;
        }
        S3ResourceClassification other = (S3ResourceClassification)obj;
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getPrefix() == null ^ this.getPrefix() == null) {
            return false;
        }
        if (other.getPrefix() != null && !other.getPrefix().equals(this.getPrefix())) {
            return false;
        }
        if (other.getClassificationType() == null ^ this.getClassificationType() == null) {
            return false;
        }
        return other.getClassificationType() == null || other.getClassificationType().equals(this.getClassificationType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getPrefix() == null ? 0 : this.getPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getClassificationType() == null ? 0 : this.getClassificationType().hashCode());
        return hashCode;
    }

    public S3ResourceClassification clone() {
        try {
            return (S3ResourceClassification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ResourceClassificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

