/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.services.machinelearning.model.S3DataSpec;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3DataSpecJsonUnmarshaller
implements Unmarshaller<S3DataSpec, JsonUnmarshallerContext> {
    private static S3DataSpecJsonUnmarshaller instance;

    public S3DataSpec unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3DataSpec s3DataSpec = new S3DataSpec();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("DataLocationS3", targetDepth)) {
                    context.nextToken();
                    s3DataSpec.setDataLocationS3((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataRearrangement", targetDepth)) {
                    context.nextToken();
                    s3DataSpec.setDataRearrangement((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataSchema", targetDepth)) {
                    context.nextToken();
                    s3DataSpec.setDataSchema((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DataSchemaLocationS3", targetDepth)) {
                    context.nextToken();
                    s3DataSpec.setDataSchemaLocationS3((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3DataSpec;
    }

    public static S3DataSpecJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3DataSpecJsonUnmarshaller();
        }
        return instance;
    }
}

