/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutequipment;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.lookoutequipment.AmazonLookoutEquipment;
import com.amazonaws.services.lookoutequipment.AmazonLookoutEquipmentClientBuilder;
import com.amazonaws.services.lookoutequipment.model.AmazonLookoutEquipmentException;
import com.amazonaws.services.lookoutequipment.model.CreateDatasetRequest;
import com.amazonaws.services.lookoutequipment.model.CreateDatasetResult;
import com.amazonaws.services.lookoutequipment.model.CreateInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.CreateInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.CreateModelRequest;
import com.amazonaws.services.lookoutequipment.model.CreateModelResult;
import com.amazonaws.services.lookoutequipment.model.DeleteDatasetRequest;
import com.amazonaws.services.lookoutequipment.model.DeleteDatasetResult;
import com.amazonaws.services.lookoutequipment.model.DeleteInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.DeleteInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.DeleteModelRequest;
import com.amazonaws.services.lookoutequipment.model.DeleteModelResult;
import com.amazonaws.services.lookoutequipment.model.DescribeDataIngestionJobRequest;
import com.amazonaws.services.lookoutequipment.model.DescribeDataIngestionJobResult;
import com.amazonaws.services.lookoutequipment.model.DescribeDatasetRequest;
import com.amazonaws.services.lookoutequipment.model.DescribeDatasetResult;
import com.amazonaws.services.lookoutequipment.model.DescribeInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.DescribeInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.DescribeModelRequest;
import com.amazonaws.services.lookoutequipment.model.DescribeModelResult;
import com.amazonaws.services.lookoutequipment.model.ListDataIngestionJobsRequest;
import com.amazonaws.services.lookoutequipment.model.ListDataIngestionJobsResult;
import com.amazonaws.services.lookoutequipment.model.ListDatasetsRequest;
import com.amazonaws.services.lookoutequipment.model.ListDatasetsResult;
import com.amazonaws.services.lookoutequipment.model.ListInferenceExecutionsRequest;
import com.amazonaws.services.lookoutequipment.model.ListInferenceExecutionsResult;
import com.amazonaws.services.lookoutequipment.model.ListInferenceSchedulersRequest;
import com.amazonaws.services.lookoutequipment.model.ListInferenceSchedulersResult;
import com.amazonaws.services.lookoutequipment.model.ListModelsRequest;
import com.amazonaws.services.lookoutequipment.model.ListModelsResult;
import com.amazonaws.services.lookoutequipment.model.ListSensorStatisticsRequest;
import com.amazonaws.services.lookoutequipment.model.ListSensorStatisticsResult;
import com.amazonaws.services.lookoutequipment.model.ListTagsForResourceRequest;
import com.amazonaws.services.lookoutequipment.model.ListTagsForResourceResult;
import com.amazonaws.services.lookoutequipment.model.StartDataIngestionJobRequest;
import com.amazonaws.services.lookoutequipment.model.StartDataIngestionJobResult;
import com.amazonaws.services.lookoutequipment.model.StartInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.StartInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.StopInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.StopInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.TagResourceRequest;
import com.amazonaws.services.lookoutequipment.model.TagResourceResult;
import com.amazonaws.services.lookoutequipment.model.UntagResourceRequest;
import com.amazonaws.services.lookoutequipment.model.UntagResourceResult;
import com.amazonaws.services.lookoutequipment.model.UpdateInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.UpdateInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.CreateDatasetRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.CreateDatasetResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.CreateInferenceSchedulerRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.CreateInferenceSchedulerResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.CreateModelRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.CreateModelResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DeleteDatasetRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DeleteDatasetResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DeleteInferenceSchedulerRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DeleteInferenceSchedulerResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DeleteModelRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DeleteModelResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeDataIngestionJobRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeDataIngestionJobResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeDatasetRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeDatasetResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeInferenceSchedulerRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeInferenceSchedulerResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeModelRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.DescribeModelResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListDataIngestionJobsRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListDataIngestionJobsResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListDatasetsRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListDatasetsResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListInferenceExecutionsRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListInferenceExecutionsResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListInferenceSchedulersRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListInferenceSchedulersResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListModelsRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListModelsResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListSensorStatisticsRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListSensorStatisticsResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.StartDataIngestionJobRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.StartDataIngestionJobResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.StartInferenceSchedulerRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.StartInferenceSchedulerResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.StopInferenceSchedulerRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.StopInferenceSchedulerResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.UpdateInferenceSchedulerRequestProtocolMarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.UpdateInferenceSchedulerResultJsonUnmarshaller;
import com.amazonaws.services.lookoutequipment.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonLookoutEquipmentClient
extends AmazonWebServiceClient
implements AmazonLookoutEquipment {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonLookoutEquipment.class);
    private static final String DEFAULT_SIGNING_NAME = "lookoutequipment";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonLookoutEquipmentException.class));

    public static AmazonLookoutEquipmentClientBuilder builder() {
        return AmazonLookoutEquipmentClientBuilder.standard();
    }

    AmazonLookoutEquipmentClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonLookoutEquipmentClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("lookoutequipment.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/lookoutequipment/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/lookoutequipment/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateDatasetResult createDataset(CreateDatasetRequest request) {
        request = (CreateDatasetRequest)this.beforeClientExecution(request);
        return this.executeCreateDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDatasetResult executeCreateDataset(CreateDatasetRequest createDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDatasetRequestProtocolMarshaller(protocolFactory).marshall((CreateDatasetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDataset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDatasetResult createDatasetResult = (CreateDatasetResult)response.getAwsResponse();
            return createDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateInferenceSchedulerResult createInferenceScheduler(CreateInferenceSchedulerRequest request) {
        request = (CreateInferenceSchedulerRequest)this.beforeClientExecution(request);
        return this.executeCreateInferenceScheduler(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateInferenceSchedulerResult executeCreateInferenceScheduler(CreateInferenceSchedulerRequest createInferenceSchedulerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createInferenceSchedulerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateInferenceSchedulerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateInferenceSchedulerRequestProtocolMarshaller(protocolFactory).marshall((CreateInferenceSchedulerRequest)super.beforeMarshalling((AmazonWebServiceRequest)createInferenceSchedulerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateInferenceScheduler");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateInferenceSchedulerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateInferenceSchedulerResult createInferenceSchedulerResult = (CreateInferenceSchedulerResult)response.getAwsResponse();
            return createInferenceSchedulerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateModelResult createModel(CreateModelRequest request) {
        request = (CreateModelRequest)this.beforeClientExecution(request);
        return this.executeCreateModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateModelResult executeCreateModel(CreateModelRequest createModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateModelRequestProtocolMarshaller(protocolFactory).marshall((CreateModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)createModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateModelResult createModelResult = (CreateModelResult)response.getAwsResponse();
            return createModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDatasetResult deleteDataset(DeleteDatasetRequest request) {
        request = (DeleteDatasetRequest)this.beforeClientExecution(request);
        return this.executeDeleteDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDatasetResult executeDeleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDatasetRequestProtocolMarshaller(protocolFactory).marshall((DeleteDatasetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDataset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDatasetResult deleteDatasetResult = (DeleteDatasetResult)response.getAwsResponse();
            return deleteDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteInferenceSchedulerResult deleteInferenceScheduler(DeleteInferenceSchedulerRequest request) {
        request = (DeleteInferenceSchedulerRequest)this.beforeClientExecution(request);
        return this.executeDeleteInferenceScheduler(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteInferenceSchedulerResult executeDeleteInferenceScheduler(DeleteInferenceSchedulerRequest deleteInferenceSchedulerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteInferenceSchedulerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteInferenceSchedulerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteInferenceSchedulerRequestProtocolMarshaller(protocolFactory).marshall((DeleteInferenceSchedulerRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteInferenceSchedulerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteInferenceScheduler");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteInferenceSchedulerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteInferenceSchedulerResult deleteInferenceSchedulerResult = (DeleteInferenceSchedulerResult)response.getAwsResponse();
            return deleteInferenceSchedulerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteModelResult deleteModel(DeleteModelRequest request) {
        request = (DeleteModelRequest)this.beforeClientExecution(request);
        return this.executeDeleteModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteModelResult executeDeleteModel(DeleteModelRequest deleteModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteModelRequestProtocolMarshaller(protocolFactory).marshall((DeleteModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteModelResult deleteModelResult = (DeleteModelResult)response.getAwsResponse();
            return deleteModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDataIngestionJobResult describeDataIngestionJob(DescribeDataIngestionJobRequest request) {
        request = (DescribeDataIngestionJobRequest)this.beforeClientExecution(request);
        return this.executeDescribeDataIngestionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDataIngestionJobResult executeDescribeDataIngestionJob(DescribeDataIngestionJobRequest describeDataIngestionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDataIngestionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDataIngestionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDataIngestionJobRequestProtocolMarshaller(protocolFactory).marshall((DescribeDataIngestionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDataIngestionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDataIngestionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDataIngestionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDataIngestionJobResult describeDataIngestionJobResult = (DescribeDataIngestionJobResult)response.getAwsResponse();
            return describeDataIngestionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDatasetResult describeDataset(DescribeDatasetRequest request) {
        request = (DescribeDatasetRequest)this.beforeClientExecution(request);
        return this.executeDescribeDataset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDatasetResult executeDescribeDataset(DescribeDatasetRequest describeDatasetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDatasetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDatasetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDatasetRequestProtocolMarshaller(protocolFactory).marshall((DescribeDatasetRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDatasetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDataset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDatasetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDatasetResult describeDatasetResult = (DescribeDatasetResult)response.getAwsResponse();
            return describeDatasetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeInferenceSchedulerResult describeInferenceScheduler(DescribeInferenceSchedulerRequest request) {
        request = (DescribeInferenceSchedulerRequest)this.beforeClientExecution(request);
        return this.executeDescribeInferenceScheduler(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeInferenceSchedulerResult executeDescribeInferenceScheduler(DescribeInferenceSchedulerRequest describeInferenceSchedulerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeInferenceSchedulerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeInferenceSchedulerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeInferenceSchedulerRequestProtocolMarshaller(protocolFactory).marshall((DescribeInferenceSchedulerRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeInferenceSchedulerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeInferenceScheduler");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeInferenceSchedulerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeInferenceSchedulerResult describeInferenceSchedulerResult = (DescribeInferenceSchedulerResult)response.getAwsResponse();
            return describeInferenceSchedulerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeModelResult describeModel(DescribeModelRequest request) {
        request = (DescribeModelRequest)this.beforeClientExecution(request);
        return this.executeDescribeModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeModelResult executeDescribeModel(DescribeModelRequest describeModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeModelRequestProtocolMarshaller(protocolFactory).marshall((DescribeModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeModelResult describeModelResult = (DescribeModelResult)response.getAwsResponse();
            return describeModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDataIngestionJobsResult listDataIngestionJobs(ListDataIngestionJobsRequest request) {
        request = (ListDataIngestionJobsRequest)this.beforeClientExecution(request);
        return this.executeListDataIngestionJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDataIngestionJobsResult executeListDataIngestionJobs(ListDataIngestionJobsRequest listDataIngestionJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDataIngestionJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDataIngestionJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDataIngestionJobsRequestProtocolMarshaller(protocolFactory).marshall((ListDataIngestionJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDataIngestionJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDataIngestionJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDataIngestionJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDataIngestionJobsResult listDataIngestionJobsResult = (ListDataIngestionJobsResult)response.getAwsResponse();
            return listDataIngestionJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDatasetsResult listDatasets(ListDatasetsRequest request) {
        request = (ListDatasetsRequest)this.beforeClientExecution(request);
        return this.executeListDatasets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDatasetsResult executeListDatasets(ListDatasetsRequest listDatasetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDatasetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDatasetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDatasetsRequestProtocolMarshaller(protocolFactory).marshall((ListDatasetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDatasetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDatasets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDatasetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDatasetsResult listDatasetsResult = (ListDatasetsResult)response.getAwsResponse();
            return listDatasetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInferenceExecutionsResult listInferenceExecutions(ListInferenceExecutionsRequest request) {
        request = (ListInferenceExecutionsRequest)this.beforeClientExecution(request);
        return this.executeListInferenceExecutions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInferenceExecutionsResult executeListInferenceExecutions(ListInferenceExecutionsRequest listInferenceExecutionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInferenceExecutionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInferenceExecutionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInferenceExecutionsRequestProtocolMarshaller(protocolFactory).marshall((ListInferenceExecutionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listInferenceExecutionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListInferenceExecutions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInferenceExecutionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInferenceExecutionsResult listInferenceExecutionsResult = (ListInferenceExecutionsResult)response.getAwsResponse();
            return listInferenceExecutionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInferenceSchedulersResult listInferenceSchedulers(ListInferenceSchedulersRequest request) {
        request = (ListInferenceSchedulersRequest)this.beforeClientExecution(request);
        return this.executeListInferenceSchedulers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInferenceSchedulersResult executeListInferenceSchedulers(ListInferenceSchedulersRequest listInferenceSchedulersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInferenceSchedulersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInferenceSchedulersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInferenceSchedulersRequestProtocolMarshaller(protocolFactory).marshall((ListInferenceSchedulersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listInferenceSchedulersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListInferenceSchedulers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInferenceSchedulersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInferenceSchedulersResult listInferenceSchedulersResult = (ListInferenceSchedulersResult)response.getAwsResponse();
            return listInferenceSchedulersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListModelsResult listModels(ListModelsRequest request) {
        request = (ListModelsRequest)this.beforeClientExecution(request);
        return this.executeListModels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListModelsResult executeListModels(ListModelsRequest listModelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listModelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListModelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListModelsRequestProtocolMarshaller(protocolFactory).marshall((ListModelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listModelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListModels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListModelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListModelsResult listModelsResult = (ListModelsResult)response.getAwsResponse();
            return listModelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSensorStatisticsResult listSensorStatistics(ListSensorStatisticsRequest request) {
        request = (ListSensorStatisticsRequest)this.beforeClientExecution(request);
        return this.executeListSensorStatistics(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSensorStatisticsResult executeListSensorStatistics(ListSensorStatisticsRequest listSensorStatisticsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSensorStatisticsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSensorStatisticsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSensorStatisticsRequestProtocolMarshaller(protocolFactory).marshall((ListSensorStatisticsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSensorStatisticsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSensorStatistics");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSensorStatisticsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSensorStatisticsResult listSensorStatisticsResult = (ListSensorStatisticsResult)response.getAwsResponse();
            return listSensorStatisticsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartDataIngestionJobResult startDataIngestionJob(StartDataIngestionJobRequest request) {
        request = (StartDataIngestionJobRequest)this.beforeClientExecution(request);
        return this.executeStartDataIngestionJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartDataIngestionJobResult executeStartDataIngestionJob(StartDataIngestionJobRequest startDataIngestionJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startDataIngestionJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartDataIngestionJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartDataIngestionJobRequestProtocolMarshaller(protocolFactory).marshall((StartDataIngestionJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startDataIngestionJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartDataIngestionJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartDataIngestionJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartDataIngestionJobResult startDataIngestionJobResult = (StartDataIngestionJobResult)response.getAwsResponse();
            return startDataIngestionJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartInferenceSchedulerResult startInferenceScheduler(StartInferenceSchedulerRequest request) {
        request = (StartInferenceSchedulerRequest)this.beforeClientExecution(request);
        return this.executeStartInferenceScheduler(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartInferenceSchedulerResult executeStartInferenceScheduler(StartInferenceSchedulerRequest startInferenceSchedulerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startInferenceSchedulerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartInferenceSchedulerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartInferenceSchedulerRequestProtocolMarshaller(protocolFactory).marshall((StartInferenceSchedulerRequest)super.beforeMarshalling((AmazonWebServiceRequest)startInferenceSchedulerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartInferenceScheduler");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartInferenceSchedulerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartInferenceSchedulerResult startInferenceSchedulerResult = (StartInferenceSchedulerResult)response.getAwsResponse();
            return startInferenceSchedulerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopInferenceSchedulerResult stopInferenceScheduler(StopInferenceSchedulerRequest request) {
        request = (StopInferenceSchedulerRequest)this.beforeClientExecution(request);
        return this.executeStopInferenceScheduler(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopInferenceSchedulerResult executeStopInferenceScheduler(StopInferenceSchedulerRequest stopInferenceSchedulerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopInferenceSchedulerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopInferenceSchedulerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopInferenceSchedulerRequestProtocolMarshaller(protocolFactory).marshall((StopInferenceSchedulerRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopInferenceSchedulerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopInferenceScheduler");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopInferenceSchedulerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopInferenceSchedulerResult stopInferenceSchedulerResult = (StopInferenceSchedulerResult)response.getAwsResponse();
            return stopInferenceSchedulerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateInferenceSchedulerResult updateInferenceScheduler(UpdateInferenceSchedulerRequest request) {
        request = (UpdateInferenceSchedulerRequest)this.beforeClientExecution(request);
        return this.executeUpdateInferenceScheduler(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateInferenceSchedulerResult executeUpdateInferenceScheduler(UpdateInferenceSchedulerRequest updateInferenceSchedulerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateInferenceSchedulerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateInferenceSchedulerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateInferenceSchedulerRequestProtocolMarshaller(protocolFactory).marshall((UpdateInferenceSchedulerRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateInferenceSchedulerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"LookoutEquipment");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateInferenceScheduler");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateInferenceSchedulerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateInferenceSchedulerResult updateInferenceSchedulerResult = (UpdateInferenceSchedulerResult)response.getAwsResponse();
            return updateInferenceSchedulerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

