/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexmodelbuilding.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.lexmodelbuilding.model.BuiltinIntentSlot;
import com.amazonaws.services.lexmodelbuilding.model.Locale;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetBuiltinIntentResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String signature;
    private List<String> supportedLocales;
    private List<BuiltinIntentSlot> slots;

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSignature() {
        return this.signature;
    }

    public GetBuiltinIntentResult withSignature(String signature) {
        this.setSignature(signature);
        return this;
    }

    public List<String> getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setSupportedLocales(Collection<String> supportedLocales) {
        if (supportedLocales == null) {
            this.supportedLocales = null;
            return;
        }
        this.supportedLocales = new ArrayList<String>(supportedLocales);
    }

    public GetBuiltinIntentResult withSupportedLocales(String ... supportedLocales) {
        if (this.supportedLocales == null) {
            this.setSupportedLocales(new ArrayList<String>(supportedLocales.length));
        }
        for (String ele : supportedLocales) {
            this.supportedLocales.add(ele);
        }
        return this;
    }

    public GetBuiltinIntentResult withSupportedLocales(Collection<String> supportedLocales) {
        this.setSupportedLocales(supportedLocales);
        return this;
    }

    public GetBuiltinIntentResult withSupportedLocales(Locale ... supportedLocales) {
        ArrayList<String> supportedLocalesCopy = new ArrayList<String>(supportedLocales.length);
        for (Locale value : supportedLocales) {
            supportedLocalesCopy.add(value.toString());
        }
        if (this.getSupportedLocales() == null) {
            this.setSupportedLocales(supportedLocalesCopy);
        } else {
            this.getSupportedLocales().addAll(supportedLocalesCopy);
        }
        return this;
    }

    public List<BuiltinIntentSlot> getSlots() {
        return this.slots;
    }

    public void setSlots(Collection<BuiltinIntentSlot> slots) {
        if (slots == null) {
            this.slots = null;
            return;
        }
        this.slots = new ArrayList<BuiltinIntentSlot>(slots);
    }

    public GetBuiltinIntentResult withSlots(BuiltinIntentSlot ... slots) {
        if (this.slots == null) {
            this.setSlots(new ArrayList<BuiltinIntentSlot>(slots.length));
        }
        for (BuiltinIntentSlot ele : slots) {
            this.slots.add(ele);
        }
        return this;
    }

    public GetBuiltinIntentResult withSlots(Collection<BuiltinIntentSlot> slots) {
        this.setSlots(slots);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSignature() != null) {
            sb.append("Signature: ").append(this.getSignature()).append(",");
        }
        if (this.getSupportedLocales() != null) {
            sb.append("SupportedLocales: ").append(this.getSupportedLocales()).append(",");
        }
        if (this.getSlots() != null) {
            sb.append("Slots: ").append(this.getSlots());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBuiltinIntentResult)) {
            return false;
        }
        GetBuiltinIntentResult other = (GetBuiltinIntentResult)obj;
        if (other.getSignature() == null ^ this.getSignature() == null) {
            return false;
        }
        if (other.getSignature() != null && !other.getSignature().equals(this.getSignature())) {
            return false;
        }
        if (other.getSupportedLocales() == null ^ this.getSupportedLocales() == null) {
            return false;
        }
        if (other.getSupportedLocales() != null && !other.getSupportedLocales().equals(this.getSupportedLocales())) {
            return false;
        }
        if (other.getSlots() == null ^ this.getSlots() == null) {
            return false;
        }
        return other.getSlots() == null || other.getSlots().equals(this.getSlots());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSignature() == null ? 0 : this.getSignature().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedLocales() == null ? 0 : this.getSupportedLocales().hashCode());
        hashCode = 31 * hashCode + (this.getSlots() == null ? 0 : this.getSlots().hashCode());
        return hashCode;
    }

    public GetBuiltinIntentResult clone() {
        try {
            return (GetBuiltinIntentResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

