/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lambda.model.ImageConfig;
import java.util.List;

@SdkInternalApi
public class ImageConfigMarshaller {
    private static final MarshallingInfo<List> ENTRYPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EntryPoint").build();
    private static final MarshallingInfo<List> COMMAND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Command").build();
    private static final MarshallingInfo<String> WORKINGDIRECTORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkingDirectory").build();
    private static final ImageConfigMarshaller instance = new ImageConfigMarshaller();

    public static ImageConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImageConfig imageConfig, ProtocolMarshaller protocolMarshaller) {
        if (imageConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(imageConfig.getEntryPoint(), ENTRYPOINT_BINDING);
            protocolMarshaller.marshall(imageConfig.getCommand(), COMMAND_BINDING);
            protocolMarshaller.marshall((Object)imageConfig.getWorkingDirectory(), WORKINGDIRECTORY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

