/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.UpdateFunctionCodeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateFunctionCodeRequestMarshaller
implements Marshaller<Request<UpdateFunctionCodeRequest>, UpdateFunctionCodeRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<UpdateFunctionCodeRequest> marshall(UpdateFunctionCodeRequest updateFunctionCodeRequest) {
        if (updateFunctionCodeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateFunctionCodeRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}/code";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", updateFunctionCodeRequest.getFunctionName() != null ? StringUtils.fromString((String)updateFunctionCodeRequest.getFunctionName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (updateFunctionCodeRequest.getZipFile() != null) {
                jsonGenerator.writeFieldName("ZipFile").writeValue(updateFunctionCodeRequest.getZipFile());
            }
            if (updateFunctionCodeRequest.getS3Bucket() != null) {
                jsonGenerator.writeFieldName("S3Bucket").writeValue(updateFunctionCodeRequest.getS3Bucket());
            }
            if (updateFunctionCodeRequest.getS3Key() != null) {
                jsonGenerator.writeFieldName("S3Key").writeValue(updateFunctionCodeRequest.getS3Key());
            }
            if (updateFunctionCodeRequest.getS3ObjectVersion() != null) {
                jsonGenerator.writeFieldName("S3ObjectVersion").writeValue(updateFunctionCodeRequest.getS3ObjectVersion());
            }
            if (updateFunctionCodeRequest.getPublish() != null) {
                jsonGenerator.writeFieldName("Publish").writeValue(updateFunctionCodeRequest.getPublish().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

